/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.library.ninepatch;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.jeitweaker.library.ninepatch.InvalidNinePatchDataException;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchBehavior;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchImage;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchRegion;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public final class NinePatchDrawable
implements IDrawable {
    private static final Drawer[] DRAWERS = new Drawer[]{NinePatchDrawable::drawNoneStretchingNinePatch, NinePatchDrawable::drawVerticallyStretchingNinePatch, NinePatchDrawable::drawHorizontallyStretchingNinePatch, NinePatchDrawable::drawBothStretchingNinePatch};
    private final int expectedWidth;
    private final int expectedHeight;
    private final float texWidth;
    private final float texHeight;
    private final Supplier<NinePatchImage> image;

    private NinePatchDrawable(ResourceLocation atlas, int u, int v, int width, int height, int expectedWidth, int expectedHeight, int texWidth, int texHeight) {
        this.expectedWidth = expectedWidth;
        this.expectedHeight = expectedHeight;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.image = Suppliers.memoize(() -> NinePatchDrawable.data(atlas, u, v, width, height, texWidth, texHeight));
    }

    public static NinePatchDrawable of(ResourceLocation atlas, int u, int v, int width, int height, int expectedWidth, int expectedHeight, int textureWidth, int textureHeight) {
        return new NinePatchDrawable(atlas, u, v, width, height, expectedWidth, expectedHeight, textureWidth, textureHeight);
    }

    public static NinePatchDrawable of(ResourceLocation atlas, int u, int v, int width, int height, int expectedWidth, int expectedHeight) {
        return NinePatchDrawable.of(atlas, u, v, width, height, expectedWidth, expectedHeight, 256, 256);
    }

    private static NinePatchImage data(ResourceLocation atlas, int u, int v, int width, int height, int texWidth, int texHeight) {
        try {
            NinePatchImage image = NinePatchImage.from(atlas, u, v, width, height, texWidth, texHeight);
            if (image.horizontal() != null && image.vertical() != null) {
                CraftTweakerAPI.LOGGER.error("Both horizontal and vertical 9-patch behavior is not yet supported");
            }
            return image;
        }
        catch (InvalidNinePatchDataException e) {
            CraftTweakerAPI.LOGGER.error("An error occurred while loading 9-patch data texture", (Throwable)e);
            return null;
        }
    }

    public int getWidth() {
        return this.expectedWidth;
    }

    public int getHeight() {
        return this.expectedHeight;
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        NinePatchImage image = this.image.get();
        if (image == null) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)image.atlas());
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        this.drawNinePatch(image, buffer, pose, xOffset, yOffset);
        tessellator.m_85914_();
    }

    private void drawNinePatch(NinePatchImage image, BufferBuilder buffer, Matrix4f pose, int xOffset, int yOffset) {
        this.findDrawer(image).draw(this, image, buffer, pose, xOffset, yOffset);
    }

    private Drawer findDrawer(NinePatchImage image) {
        return DRAWERS[(image.horizontal() == null ? 0 : 2) | (image.vertical() == null ? 0 : 1)];
    }

    private void drawNoneStretchingNinePatch(NinePatchImage image, BufferBuilder buffer, Matrix4f pose, int xOffset, int yOffset) {
        this.quad(buffer, pose, xOffset, yOffset, this.expectedWidth, this.expectedHeight, image.u(), image.v(), image.width(), image.height());
    }

    private void drawVerticallyStretchingNinePatch(NinePatchImage image, BufferBuilder buffer, Matrix4f pose, int xOffset, int yOffset) {
        NinePatchRegion region = Objects.requireNonNull(image.vertical());
        int ninePatchY = region.beginning();
        int notNinePatchSize = image.height() - region.size();
        int ninePatchDim = this.expectedHeight - notNinePatchSize;
        this.quad(buffer, pose, xOffset, yOffset, this.expectedWidth, ninePatchY, image.u(), image.v(), image.width(), ninePatchY);
        if (region.behavior() == NinePatchBehavior.STRETCH) {
            this.quad(buffer, pose, xOffset, yOffset + ninePatchY, this.expectedWidth, ninePatchDim, image.u(), ninePatchY, image.width(), region.size());
        } else if (region.behavior() == NinePatchBehavior.TILE) {
            int quantity = ninePatchDim / region.size();
            int difference = ninePatchDim - quantity * region.size();
            int y = yOffset + ninePatchY;
            for (int i = 0; i < quantity; ++i) {
                this.quad(buffer, pose, xOffset, y, this.expectedWidth, region.size(), image.u(), ninePatchY, image.width(), region.size());
                y = (int)((float)y + (float)region.size());
            }
            if (difference > 0) {
                this.quad(buffer, pose, xOffset, y, this.expectedWidth, difference, image.u(), ninePatchY, image.width(), region.size());
            }
        } else {
            throw new IllegalStateException(region.behavior().name());
        }
        int regionEnd = ninePatchY + region.size();
        int lastQuadY = ninePatchY + ninePatchDim;
        int lastQuadSize = image.height() - regionEnd;
        this.quad(buffer, pose, xOffset, yOffset + lastQuadY, this.expectedWidth, this.expectedHeight - lastQuadY, image.u(), regionEnd + 1, image.width(), lastQuadSize);
    }

    private void drawHorizontallyStretchingNinePatch(NinePatchImage image, BufferBuilder buffer, Matrix4f pose, int xOffset, int yOffset) {
        NinePatchRegion region = Objects.requireNonNull(image.horizontal());
        int ninePatchX = region.beginning();
        int notNinePatchSize = image.width() - region.size();
        int ninePatchDim = this.expectedWidth - notNinePatchSize;
        this.quad(buffer, pose, xOffset, yOffset, ninePatchX, this.expectedHeight, image.u(), image.v(), ninePatchX, image.height());
        if (region.behavior() == NinePatchBehavior.STRETCH) {
            this.quad(buffer, pose, xOffset + ninePatchX, yOffset, ninePatchDim, this.expectedHeight, ninePatchX, image.v(), region.size(), image.height());
        } else if (region.behavior() == NinePatchBehavior.TILE) {
            int quantity = ninePatchDim / region.size();
            int difference = ninePatchDim - quantity * region.size();
            int x = xOffset + ninePatchX;
            for (int i = 0; i < quantity; ++i) {
                this.quad(buffer, pose, x, yOffset, region.size(), this.expectedHeight, ninePatchX, image.v(), region.size(), image.height());
                x = (int)((float)x + (float)region.size());
            }
            if (difference > 0) {
                this.quad(buffer, pose, x, yOffset, difference, this.expectedHeight, ninePatchX, image.v(), region.size(), image.height());
            }
        } else {
            throw new IllegalStateException(region.behavior().name());
        }
        int regionEnd = ninePatchX + region.size();
        int lastQuadX = ninePatchX + ninePatchDim;
        int lastQuadSize = image.width() - regionEnd;
        this.quad(buffer, pose, xOffset + lastQuadX, yOffset, this.expectedWidth - lastQuadX, this.expectedHeight, regionEnd + 1, image.v(), lastQuadSize, image.height());
    }

    private void drawBothStretchingNinePatch(NinePatchImage image, BufferBuilder buffer, Matrix4f pose, int xOffset, int yOffset) {
        this.drawVerticallyStretchingNinePatch(image, buffer, pose, xOffset, yOffset);
    }

    private void quad(BufferBuilder buffer, Matrix4f pose, float x, float y, float width, float height, float u, float v, float textureWidth, float textureHeight) {
        float un = 1.0f / this.texWidth;
        float vn = 1.0f / this.texHeight;
        this.vertexData(buffer, pose, x, y, u * un, v * vn);
        this.vertexData(buffer, pose, x, y + height, u * un, (v + textureHeight) * vn);
        this.vertexData(buffer, pose, x + width, y + height, (u + textureWidth) * un, (v + textureHeight) * vn);
        this.vertexData(buffer, pose, x + width, y, (u + textureWidth) * un, v * vn);
    }

    private void vertexData(BufferBuilder buffer, Matrix4f pose, float x, float y, float u, float v) {
        buffer.m_85982_(pose, x, y, 0.0f).m_7421_(u, v).m_5752_();
    }

    @FunctionalInterface
    private static interface Drawer {
        public void draw(NinePatchDrawable var1, NinePatchImage var2, BufferBuilder var3, Matrix4f var4, int var5, int var6);
    }
}

