/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.category;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.bridge.InputConsumingCategoryBridge;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.zen.category.SimpleJeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.JeiDrawableAnimation;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import com.mojang.datafixers.util.Pair;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Category/InputConsuming")
@ZenCodeType.Name(value="mods.jei.category.InputConsuming")
@ZenRegister(modDeps={"jei"})
public final class InputConsumingCategory
extends SimpleJeiCategory {
    private static final JeiDrawable BACKGROUND = JeiDrawable.of(GUI_ATLAS, 94, 20, 162, 49);
    private static final JeiDrawable DEFAULT_BG = JeiDrawable.of(GUI_ATLAS, 232, 232, 24, 24);
    private static final JeiDrawable DEFAULT_ANIM = JeiDrawable.ofAnimated(GUI_ATLAS, 208, 232, 24, 24, 35, JeiDrawableAnimation.SHOW_BOTTOM_TO_TOP);
    private Pair<JeiDrawable, JeiDrawable> output = Pair.of((Object)DEFAULT_BG, (Object)DEFAULT_ANIM);
    private Component baseResultText = null;

    public InputConsumingCategory(ResourceLocation id, Component name, JeiDrawable icon, RawJeiIngredient ... catalysts) {
        super(id, name, icon, catalysts);
    }

    @ZenCodeType.Method(value="setOutputDrawables")
    public void setOutputDrawables(JeiDrawable background, @ZenCodeType.Nullable JeiDrawable animation) {
        this.output = Pair.of((Object)background, (Object)animation);
    }

    @ZenCodeType.Setter(value="baseResultText")
    public void setBaseResultText(@ZenCodeType.Nullable Component baseExtra) {
        this.baseResultText = baseExtra;
    }

    @Override
    public JeiDrawable background() {
        return BACKGROUND;
    }

    @Override
    public BiPredicate<JeiRecipe, Logger> getRecipeValidator() {
        BiPredicate<JeiRecipe, Logger> validator = (recipe, logger) -> {
            if (recipe.getOutputs().length != 0) {
                logger.warn("Recipe " + recipe + " has outputs: they will be ignored in InputConsuming");
            }
            if (recipe.getInputs().length != 1) {
                logger.error("Recipe " + recipe + " has " + recipe.getInputs().length + " inputs: expected one");
                return false;
            }
            return true;
        };
        return validator.and(super.getRecipeValidator());
    }

    @Override
    public Supplier<JeiCategoryPluginBridge> getBridgeCreator() {
        return () -> new InputConsumingCategoryBridge(this.output, this.baseResultText);
    }
}

