/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.zen.category;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.bridge.OutputListCategoryBridge;
import com.blamejared.jeitweaker.zen.category.SimpleJeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import com.blamejared.jeitweaker.zen.recipe.JeiRecipe;
import com.google.common.base.Suppliers;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="mods/JEITweaker/API/Category/OutputList")
@ZenCodeType.Name(value="mods.jei.category.OutputList")
@ZenRegister(modDeps={"jei"})
public final class OutputListCategory
extends SimpleJeiCategory {
    private final Supplier<JeiDrawable> backgroundSupplier = Suppliers.memoize(() -> JeiDrawable.ofNinePatch(GUI_ATLAS, 92, 0, 164, 20, 162, 18 * this.rows));
    private int rows = 1;

    public OutputListCategory(ResourceLocation id, Component name, JeiDrawable icon, RawJeiIngredient ... catalysts) {
        super(id, name, icon, catalysts);
    }

    @ZenCodeType.Setter(value="rows")
    public void setRows(int rows) {
        this.rows = Math.max(1, rows);
    }

    @Override
    public JeiDrawable background() {
        return this.backgroundSupplier.get();
    }

    @Override
    public BiPredicate<JeiRecipe, Logger> getRecipeValidator() {
        BiPredicate<JeiRecipe, Logger> validator = (recipe, logger) -> {
            if (recipe.getInputs().length != 0) {
                logger.warn("Recipe {} has inputs: they will be ignored in OutputList", recipe);
            }
            if (recipe.getOutputs().length > this.rows * 9) {
                logger.error(String.format("Recipe %s has %d outputs, but only %d are supported with this configuration of OutputList", recipe, recipe.getOutputs().length, this.rows * 9));
                return false;
            }
            return true;
        };
        return validator.and(super.getRecipeValidator());
    }

    @Override
    public Supplier<JeiCategoryPluginBridge> getBridgeCreator() {
        return () -> new OutputListCategoryBridge(() -> this.rows);
    }
}

