/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.tomes;

import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.util.ExperienceHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;

@FunctionalInterface
public interface TomeEffect<T, R> {
    @Nullable
    public R apply(ItemStack var1, Player var2, InteractionHand var3, T var4);

    public static <T, R> TomeEffect<T, R> withCooldown(TomeEffect<T, R> effect, int cooldown) {
        return (stack, user, hand, target) -> {
            ItemCooldowns cooldowns = user.m_36335_();
            if (!cooldowns.m_41519_(stack.m_41720_())) {
                cooldowns.m_41524_(stack.m_41720_(), cooldown);
                return effect.apply(stack, user, hand, target);
            }
            return null;
        };
    }

    public static <T, R> TomeEffect<T, R> withExpCost(TomeEffect<T, R> effect, int pointCost) {
        return (stack, user, hand, target) -> {
            if (ExperienceHelper.chargeExperiencePoints((Player)user, (int)pointCost)) {
                return effect.apply(stack, user, hand, target);
            }
            return null;
        };
    }
}

