/*
 * Decompiled with CFR 0.152.
 */
package iskallia.shulkerplus.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public abstract class Config {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    protected String root = "config%s%s%s".formatted(File.separator, "shulkerplus", File.separator);
    protected String extension = ".json";

    public abstract String getPath();

    protected abstract void reset();

    private File getConfigFile() {
        return new File(this.root + this.getPath() + this.extension);
    }

    public void write() throws IOException {
        File dir = new File(this.root);
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        if (!this.getConfigFile().exists() && !this.getConfigFile().createNewFile()) {
            return;
        }
        FileWriter writer = new FileWriter(this.getConfigFile());
        GSON.toJson((Object)this, (Appendable)writer);
        writer.flush();
        writer.close();
    }

    public <T extends Config> T read() {
        try {
            return (T)((Config)GSON.fromJson((Reader)new FileReader(this.getConfigFile()), this.getClass()));
        }
        catch (FileNotFoundException ignored) {
            this.reset();
            try {
                this.write();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return (T)this;
        }
    }
}

