/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.tileentity.MailBoxBlockEntity;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class MailBoxBlock
extends FurnitureHorizontalWaterloggedBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public MailBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] POST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)13.0, (double)9.5), Direction.SOUTH));
        VoxelShape[] BOX = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)4.0, (double)13.0, (double)2.0, (double)12.0, (double)22.0, (double)14.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(POST[direction.m_122416_()]);
            shapes.add(BOX[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (entity instanceof ServerPlayer && (blockEntity = level.m_7702_(pos)) instanceof MailBoxBlockEntity) {
            MailBoxBlockEntity blockEntity2 = (MailBoxBlockEntity)blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            blockEntity2.setId(UUID.randomUUID());
            blockEntity2.setOwner(serverPlayer);
            blockEntity2.setMailBoxName("Mail Box");
            PostOffice.registerMailBox(serverPlayer, blockEntity2.getId(), "Mail Box", pos);
            BlockEntityUtil.sendUpdatePacket((BlockEntity)blockEntity2);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        MailBoxBlockEntity mailBox;
        BlockEntity tileEntity;
        if (!level.m_5776_() && (tileEntity = level.m_7702_(pos)) instanceof MailBoxBlockEntity && (mailBox = (MailBoxBlockEntity)tileEntity).getId() != null && mailBox.getOwnerId() != null) {
            Mail mail;
            Supplier<Mail> supplier = PostOffice.getMailForPlayerMailBox(mailBox.getOwnerId(), mailBox.getId());
            while ((mail = supplier.get()) != null) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)mail.getStack());
            }
            PostOffice.unregisterMailBox(mailBox.getOwnerId(), mailBox.getId());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof MailBoxBlockEntity) {
            MailBoxBlockEntity blockEntity2 = (MailBoxBlockEntity)blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            blockEntity2.updateIdAndAttemptClaim(serverPlayer);
            blockEntity2.updateOwnerName(serverPlayer);
            BlockEntityUtil.sendUpdatePacket((BlockEntity)blockEntity2);
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)blockEntity2, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MailBoxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MailBoxBlock.createMailBoxTicker(level, type, (BlockEntityType<? extends MailBoxBlockEntity>)((BlockEntityType)ModBlockEntities.MAIL_BOX.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createMailBoxTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends MailBoxBlockEntity> mailBoxBlockEntityType) {
        return level.m_5776_() ? null : MailBoxBlock.createTickerHelper(blockEntityType, mailBoxBlockEntityType, MailBoxBlockEntity::serverTick);
    }
}

