/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.KitchenSinkBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;

public class KitchenSinkBlockEntityRenderer
implements BlockEntityRenderer<KitchenSinkBlockEntity> {
    public KitchenSinkBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(KitchenSinkBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        Direction direction = (Direction)tileEntity.m_58900_().m_61143_((Property)FurnitureHorizontalBlock.DIRECTION);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)direction.m_122416_() * -90.0f - 90.0f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        this.drawFluid(tileEntity, poseStack, source, 0.125f, 0.625f, 0.125f, 0.625f, 0.3125f, 0.75f, light);
        poseStack.m_85849_();
    }

    private void drawFluid(KitchenSinkBlockEntity te, PoseStack poseStack, MultiBufferSource source, float x, float y, float z, float width, float height, float depth, int light) {
        Fluid fluid = te.getTank().getFluid().getFluid();
        if (fluid == Fluids.f_76191_) {
            return;
        }
        TextureAtlasSprite sprite = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)te.m_58904_(), (BlockPos)te.m_58899_(), (FluidState)fluid.m_76145_())[0];
        float minU = sprite.m_118409_();
        float maxU = Math.min(minU + (sprite.m_118410_() - minU) * depth, sprite.m_118410_());
        float minV = sprite.m_118411_();
        float maxV = Math.min(minV + (sprite.m_118412_() - minV) * width, sprite.m_118412_());
        int waterColor = fluid.getAttributes().getColor((BlockAndTintGetter)te.m_58904_(), te.m_58899_());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        height = (float)((double)height * ((double)te.getTank().getFluidAmount() / (double)te.getTank().getCapacity()));
        VertexConsumer consumer = source.m_6299_(RenderType.m_110466_());
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        consumer.m_85982_(matrix, x, y + height, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(matrix, x, y + height, z + depth).m_85950_(red, green, blue, 1.0f).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(matrix, x + width, y + height, z + depth).m_85950_(red, green, blue, 1.0f).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(matrix, x + width, y + height, z).m_85950_(red, green, blue, 1.0f).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

