/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModSoundEvents;

public class ThinIceBlock
extends IceBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;

    public ThinIceBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76276_).m_60911_(0.98f).m_60978_(0.5f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((state, blockGetter, pos, entityType) -> entityType.equals(EntityType.f_20514_) || entityType.equals(ModEntityTypes.PENGUIN.get())));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        Player player;
        if (pEntity instanceof Player && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44967_, (LivingEntity)(player = (Player)pEntity)) == 0) {
            pLevel.m_5594_(null, pPos, ModSoundEvents.THIN_ICE_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.f_46441_.nextFloat() * 0.2f);
            this.replaceIfThinIce(pPos, 3, pLevel);
            this.replaceIfThinIce(pPos.m_142127_(), 2, pLevel);
            this.replaceIfThinIce(pPos.m_142126_(), 2, pLevel);
            this.replaceIfThinIce(pPos.m_142128_(), 2, pLevel);
            this.replaceIfThinIce(pPos.m_142125_(), 2, pLevel);
            this.replaceIfThinIce(pPos.m_142127_().m_142125_(), 1, pLevel);
            this.replaceIfThinIce(pPos.m_142127_().m_142126_(), 1, pLevel);
            this.replaceIfThinIce(pPos.m_142128_().m_142125_(), 1, pLevel);
            this.replaceIfThinIce(pPos.m_142128_().m_142126_(), 1, pLevel);
        }
    }

    private void replaceIfThinIce(BlockPos pPos, int age, Level pLevel) {
        BlockState state = pLevel.m_8055_(pPos);
        if (state.m_60713_((Block)ModBlocks.THIN_ICE.get())) {
            pLevel.m_7731_(pPos, (BlockState)ModBlocks.THIN_ICE.get().m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min((Integer)state.m_61143_((Property)AGE) + age, 3))), 2);
        }
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pEntity instanceof Player && (Integer)pState.m_61143_((Property)AGE) > 0) {
            this.crack(pState, pLevel, pPos);
        }
    }

    private boolean crack(BlockState pState, Level pLevel, BlockPos pPos) {
        Material material;
        int age = (Integer)pState.m_61143_((Property)AGE);
        if (age < 3) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            pLevel.m_5594_(null, pPos, ModSoundEvents.THIN_ICE_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.f_46441_.nextFloat() * 0.2f);
            return false;
        }
        pLevel.m_7471_(pPos, false);
        if (!pLevel.m_6042_().m_63951_() && ((material = pLevel.m_8055_(pPos.m_7495_()).m_60767_()).m_76334_() || material.m_76332_())) {
            pLevel.m_46597_(pPos, Blocks.f_49990_.m_49966_());
        }
        pLevel.m_5594_(null, pPos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{AGE});
    }
}

