/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.worldgen.feature;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.GlowLichenFeature;
import net.minecraft.world.level.levelgen.feature.configurations.GlowLichenConfiguration;
import samebutdifferent.ecologics.block.SurfaceMossBlock;
import samebutdifferent.ecologics.registry.ModBlocks;

public class SurfaceMossFeature
extends GlowLichenFeature {
    public SurfaceMossFeature(Codec<GlowLichenConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GlowLichenConfiguration> context) {
        WorldGenLevel worldGenLevel = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        Random random = context.m_159776_();
        GlowLichenConfiguration configuration = (GlowLichenConfiguration)context.m_159778_();
        if (!SurfaceMossFeature.isAirOrWater(worldGenLevel.m_8055_(blockPos))) {
            return false;
        }
        List directions = SurfaceMossFeature.m_159848_((GlowLichenConfiguration)configuration, (Random)random);
        if (SurfaceMossFeature.placeGlowLichenIfPossible(worldGenLevel, blockPos, worldGenLevel.m_8055_(blockPos), configuration, random, directions)) {
            return true;
        }
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
        block0: for (Direction direction : directions) {
            mutableBlockPos.m_122190_((Vec3i)blockPos);
            List directionsExcept = SurfaceMossFeature.m_159851_((GlowLichenConfiguration)configuration, (Random)random, (Direction)direction.m_122424_());
            for (int i = 0; i < configuration.f_160870_; ++i) {
                mutableBlockPos.m_122159_((Vec3i)blockPos, direction);
                BlockState blockState = worldGenLevel.m_8055_((BlockPos)mutableBlockPos);
                if (!SurfaceMossFeature.isAirOrWater(blockState) && !blockState.m_60713_((Block)ModBlocks.SURFACE_MOSS.get())) continue block0;
                if (!SurfaceMossFeature.placeGlowLichenIfPossible(worldGenLevel, (BlockPos)mutableBlockPos, blockState, configuration, random, directionsExcept)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean placeGlowLichenIfPossible(WorldGenLevel level, BlockPos pos, BlockState state, GlowLichenConfiguration config, Random random, List<Direction> directions) {
        Direction direction;
        BlockState blockState;
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        Iterator<Direction> iterator = directions.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(blockState = level.m_8055_((BlockPos)mutableBlockPos.m_122159_((Vec3i)pos, direction = iterator.next()))).m_204341_(config.f_160875_));
        SurfaceMossBlock surfaceMossBlock = ModBlocks.SURFACE_MOSS.get();
        BlockState blockState2 = surfaceMossBlock.m_153940_(state, (BlockGetter)level, pos, direction);
        if (blockState2 == null) {
            return false;
        }
        level.m_7731_(pos, (BlockState)blockState2.m_61124_((Property)SurfaceMossBlock.LAYERS, (Comparable)Integer.valueOf(random.nextInt(3) + 1)), 3);
        level.m_46865_(pos).m_8113_(pos);
        if (random.nextFloat() < config.f_160874_) {
            surfaceMossBlock.m_153873_((BlockState)blockState2.m_61124_((Property)SurfaceMossBlock.LAYERS, (Comparable)Integer.valueOf(random.nextInt(3) + 1)), (LevelAccessor)level, pos, direction, random, true);
        }
        return true;
    }

    private static boolean isAirOrWater(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_);
    }
}

