/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.moddingplayground.twigs.init.TwigsEntityTypeTags;

public class BambooLeavesBlock
extends BushBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty LAYERS = IntegerProperty.m_61631_((String)"layers", (int)1, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE_ONE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape SHAPE_TWO = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SHAPE_THREE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape SHAPE_FOUR = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);

    public BambooLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        return !floor.m_60812_(world, pos).m_83263_(Direction.UP).m_83281_() || floor.m_60783_(world, pos, Direction.UP);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        return this.m_6266_(world.m_8055_(blockPos), (BlockGetter)world, blockPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)LAYERS) < 4 || super.m_6864_(state, context);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)blockState.m_61122_((Property)LAYERS);
        }
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)Objects.requireNonNull(super.m_5573_(ctx)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)LAYERS)) {
            default -> SHAPE_ONE;
            case 2 -> SHAPE_TWO;
            case 3 -> SHAPE_THREE;
            case 4 -> SHAPE_FOUR;
        };
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if ((Integer)state.m_61143_((Property)LAYERS) > 2 && entity instanceof LivingEntity && entity.m_6095_().m_204039_(TwigsEntityTypeTags.BAMBOO_LEAVES_SLOW_IMMUNE)) {
            entity.m_7601_(state, new Vec3(0.75, 1.0, 0.75));
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_183324_().m_183588_(pos, (Object)Fluids.f_76193_);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LAYERS, WATERLOGGED});
    }
}

