/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.moddingplayground.twigs.init.TwigsBlocks;
import net.moddingplayground.twigs.init.TwigsEntityTypes;
import net.moddingplayground.twigs.init.TwigsItems;

public class StrippedBambooBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(StrippedBambooBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public StrippedBambooBoatEntity(EntityType<? extends Boat> type, Level p_38291_) {
        super(type, p_38291_);
        this.f_19850_ = true;
    }

    public StrippedBambooBoatEntity(Level world, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)TwigsEntityTypes.STRIPPED_BAMBOO_BOAT.get()), world);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)BoatType.STRIPPED_BAMBOO.ordinal());
    }

    public Item m_38369_() {
        return (Item)TwigsItems.STRIPPED_BAMBOO_BOAT.get();
    }

    public void setBoatType(BoatType type) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)type.ordinal());
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Type", this.getBoatTypeDropItem().getName());
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Type", 8)) {
            this.setBoatType(BoatType.byName(tag.m_128461_("Type")));
        }
    }

    public BoatType getBoatTypeDropItem() {
        return BoatType.byId((Integer)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum BoatType {
        STRIPPED_BAMBOO((Block)TwigsBlocks.STRIPPED_BAMBOO_PLANKS.get(), "stripped_bamboo");

        private final String name;
        private final Block planks;

        private BoatType(Block block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int id) {
            BoatType[] aboat$type = BoatType.values();
            if (id < 0 || id >= aboat$type.length) {
                id = 0;
            }
            return aboat$type[id];
        }

        public static BoatType byName(String name) {
            BoatType[] types;
            for (BoatType type : types = BoatType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }
    }
}

