/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorldCoord {
    public int x;
    public int y;
    public int z;

    public WorldCoord(BlockEntity s) {
        this(s.m_58899_());
    }

    public WorldCoord(int _x, int _y, int _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public WorldCoord(BlockPos pos) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    public WorldCoord subtract(Direction direction, int length) {
        this.x -= direction.m_122429_() * length;
        this.y -= direction.m_122430_() * length;
        this.z -= direction.m_122431_() * length;
        return this;
    }

    public WorldCoord add(int _x, int _y, int _z) {
        this.x += _x;
        this.y += _y;
        this.z += _z;
        return this;
    }

    public WorldCoord subtract(int _x, int _y, int _z) {
        this.x -= _x;
        this.y -= _y;
        this.z -= _z;
        return this;
    }

    public WorldCoord multiple(int _x, int _y, int _z) {
        this.x *= _x;
        this.y *= _y;
        this.z *= _z;
        return this;
    }

    public WorldCoord divide(int _x, int _y, int _z) {
        this.x /= _x;
        this.y /= _y;
        this.z /= _z;
        return this;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Direction directionTo(WorldCoord loc) {
        int ox = this.x - loc.x;
        int oy = this.y - loc.y;
        int oz = this.z - loc.z;
        int xlen = Math.abs(ox);
        int ylen = Math.abs(oy);
        int zlen = Math.abs(oz);
        if (loc.isEqual(this.copy().add(Direction.EAST, xlen))) {
            return Direction.EAST;
        }
        if (loc.isEqual(this.copy().add(Direction.WEST, xlen))) {
            return Direction.WEST;
        }
        if (loc.isEqual(this.copy().add(Direction.NORTH, zlen))) {
            return Direction.NORTH;
        }
        if (loc.isEqual(this.copy().add(Direction.SOUTH, zlen))) {
            return Direction.SOUTH;
        }
        if (loc.isEqual(this.copy().add(Direction.UP, ylen))) {
            return Direction.UP;
        }
        if (loc.isEqual(this.copy().add(Direction.DOWN, ylen))) {
            return Direction.DOWN;
        }
        return null;
    }

    public boolean isEqual(WorldCoord c) {
        return this.x == c.x && this.y == c.y && this.z == c.z;
    }

    public WorldCoord add(Direction direction, int length) {
        this.x += direction.m_122429_() * length;
        this.y += direction.m_122430_() * length;
        this.z += direction.m_122431_() * length;
        return this;
    }

    public WorldCoord copy() {
        return new WorldCoord(this.x, this.y, this.z);
    }

    public int hashCode() {
        return this.y << 24 ^ this.x ^ this.z;
    }

    public boolean equals(Object obj) {
        return obj instanceof WorldCoord && this.isEqual((WorldCoord)obj);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y + ", z=" + this.z;
    }
}

