/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.qnb;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AECableType;
import appeng.block.qnb.QnbFormedState;
import appeng.block.qnb.QuantumRingBlock;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.util.inv.AppEngInternalInventory;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class QuantumBridgeBlockEntity
extends AENetworkInvBlockEntity
implements IAEMultiBlock<QuantumCluster>,
ServerTickingBlockEntity {
    public static final ModelProperty<QnbFormedState> FORMED_STATE = new ModelProperty();
    private final byte corner = (byte)16;
    private final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1, 1);
    private final byte hasSingularity = (byte)32;
    private final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    private byte constructed = (byte)-1;
    private QuantumCluster cluster;
    private boolean updateStatus = false;

    public QuantumBridgeBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(Direction.class));
        this.getMainNode().setFlags(GridFlags.DENSE_CAPACITY);
        this.getMainNode().setIdlePowerUsage(22.0);
    }

    @Override
    public void serverTick() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        int out = this.constructed;
        if (!this.internalInventory.getStackInSlot(0).m_41619_() && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.getMainNode().isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        return this.constructed != oldValue || c;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    protected InternalInventory getExposedInventoryForSide(Direction side) {
        if (this.isCenter()) {
            return this.internalInventory;
        }
        return InternalInventory.empty();
    }

    private boolean isCenter() {
        return this.m_58900_().m_60713_((Block)AEBlocks.QUANTUM_LINK.block());
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.updateStatus = true;
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        super.onReady();
        BlockDefinition<QuantumRingBlock> quantumRing = AEBlocks.QUANTUM_RING;
        if (this.m_58900_().m_60734_() == quantumRing.block()) {
            this.getMainNode().setVisualRepresentation(quantumRing.stack());
        }
        this.updateStatus = true;
    }

    @Override
    public void m_7651_() {
        this.disconnect(false);
        super.m_7651_();
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.setUpdateStatus(false);
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.getMainNode().setExposedOnSides(EnumSet.noneOf(Direction.class));
        }
    }

    @Override
    public QuantumCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.m_58901_();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                EnumSet<Direction> sides = EnumSet.copyOf(this.getAdjacentQuantumBridges());
                this.getMainNode().setExposedOnSides(sides);
            } else {
                this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
            }
        }
    }

    public boolean isCorner() {
        return (this.constructed & this.getCorner()) == this.getCorner() && this.constructed != -1;
    }

    public EnumSet<Direction> getAdjacentQuantumBridges() {
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction d : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(d));
            if (!(te instanceof QuantumBridgeBlockEntity)) continue;
            set.add(d);
        }
        return set;
    }

    public long getQEFrequency() {
        CompoundTag c;
        ItemStack is = this.internalInventory.getStackInSlot(0);
        if (!is.m_41619_() && (c = is.m_41783_()) != null) {
            return c.m_128454_("freq");
        }
        return 0L;
    }

    public boolean isPowered() {
        if (this.isClientSide()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        IGridNode node = this.getMainNode().getNode();
        return node != null && node.isPowered();
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.DENSE_SMART;
    }

    public void neighborUpdate(BlockPos fromPos) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.f_58858_, fromPos);
        }
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakClusterOnRemove() {
        if (this.cluster != null) {
            this.f_58859_ = true;
            this.cluster.destroy();
        }
    }

    public byte getCorner() {
        return this.corner;
    }

    @Override
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FORMED_STATE, (Object)new QnbFormedState(this.getAdjacentQuantumBridges(), this.isCorner(), this.isPowered())).build();
    }
}

