/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.AbstractTableRenderer;
import appeng.client.gui.me.crafting.CraftConfirmTableRenderer;
import appeng.client.gui.me.crafting.CraftErrorScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.GuiText;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.me.crafting.CraftingPlanSummary;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class CraftConfirmScreen
extends AEBaseScreen<CraftConfirmMenu> {
    private final CraftConfirmTableRenderer table = new CraftConfirmTableRenderer(this, 9, 19);
    private final Button start;
    private final Button selectCPU;
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");

    public CraftConfirmScreen(CraftConfirmMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.start = this.widgets.addButton("start", (Component)GuiText.Start.text(), this::start);
        this.start.f_93623_ = false;
        this.selectCPU = this.widgets.addButton("selectCpu", this.getNextCpuButtonLabel(), this::selectNextCpu);
        this.selectCPU.f_93623_ = false;
        this.widgets.addButton("cancel", (Component)GuiText.Cancel.text(), menu::goBack);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        ICraftingSubmitResult errorResult = ((CraftConfirmMenu)this.f_97732_).submitError.result();
        if (errorResult != null && errorResult.errorCode() != null) {
            this.switchToScreen(new CraftErrorScreen(this, errorResult.errorCode(), errorResult.errorDetail()));
            return;
        }
        this.selectCPU.m_93666_(this.getNextCpuButtonLabel());
        CraftingPlanSummary plan = ((CraftConfirmMenu)this.f_97732_).getPlan();
        boolean planIsStartable = plan != null && !plan.isSimulation();
        this.start.f_93623_ = !((CraftConfirmMenu)this.f_97732_).hasNoCPU() && planIsStartable;
        this.selectCPU.f_93623_ = planIsStartable;
        MutableComponent planDetails = GuiText.CalculatingWait.text();
        Component cpuDetails = TextComponent.f_131282_;
        if (plan != null) {
            String byteUsed = NumberFormat.getInstance().format(plan.getUsedBytes());
            planDetails = GuiText.BytesUsed.text(byteUsed);
            cpuDetails = plan.isSimulation() ? GuiText.PartialPlan.text() : (((CraftConfirmMenu)this.f_97732_).getCpuAvailableBytes() > 0L ? GuiText.ConfirmCraftCpuStatus.text(((CraftConfirmMenu)this.f_97732_).getCpuAvailableBytes(), ((CraftConfirmMenu)this.f_97732_).getCpuCoProcessors()) : GuiText.ConfirmCraftNoCpu.text());
        }
        this.setTextContent("dialog_title", (Component)GuiText.CraftingPlan.text(planDetails));
        this.setTextContent("cpu_status", cpuDetails);
        int size = plan != null ? plan.getEntries().size() : 0;
        this.scrollbar.setRange(0, AbstractTableRenderer.getScrollableRows(size), 1);
    }

    private Component getNextCpuButtonLabel() {
        if (((CraftConfirmMenu)this.f_97732_).hasNoCPU()) {
            return GuiText.NoCraftingCPUs.text();
        }
        Object cpuName = ((CraftConfirmMenu)this.f_97732_).cpuName == null ? GuiText.Automatic.text() : ((CraftConfirmMenu)this.f_97732_).cpuName;
        return GuiText.SelectedCraftingCPU.text(cpuName);
    }

    @Override
    public void drawFG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        CraftingPlanSummary plan = ((CraftConfirmMenu)this.f_97732_).getPlan();
        if (plan != null) {
            this.table.render(poseStack, mouseX, mouseY, plan.getEntries(), this.scrollbar.getCurrentScroll());
        }
    }

    @Override
    @Nullable
    public GenericStack getStackUnderMouse(double mouseX, double mouseY) {
        GenericStack hovered = this.table.getHoveredStack();
        if (hovered != null) {
            return hovered;
        }
        return super.getStackUnderMouse(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (!(this.checkHotbarKeys(InputConstants.m_84827_((int)keyCode, (int)scanCode)) || keyCode != 257 && keyCode != 335)) {
            this.start();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
    }

    private void selectNextCpu() {
        ((CraftConfirmMenu)this.m_6262_()).cycleSelectedCPU(!this.isHandlingRightClick());
    }

    private void start() {
        ((CraftConfirmMenu)this.m_6262_()).startJob();
    }
}

