/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.search;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEKey;
import appeng.client.gui.me.search.SearchPredicates;
import appeng.core.AEConfig;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.util.Platform;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class RepoSearch {
    private String searchString = "";
    private final Long2BooleanMap cache = new Long2BooleanOpenHashMap();
    private Predicate<GridInventoryEntry> search = e -> true;
    private final Map<AEKey, String> tooltipCache = new WeakHashMap<AEKey, String>();

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        if (!searchString.equals(this.searchString)) {
            this.search = SearchPredicates.fromString(searchString, this);
            this.searchString = searchString;
            this.cache.clear();
        }
    }

    public boolean matches(GridInventoryEntry entry) {
        return this.cache.computeIfAbsent(entry.getSerial(), s -> this.search.test(entry));
    }

    public String getTooltipText(AEKey what) {
        return this.tooltipCache.computeIfAbsent(what, key -> {
            List<Component> lines = AEStackRendering.getTooltip(key);
            StringBuilder tooltipText = new StringBuilder();
            for (int i = 0; i < lines.size(); ++i) {
                Component line = lines.get(i);
                if (i > 0 && i >= lines.size() - 1 && !AEConfig.instance().isSearchModNameInTooltips()) {
                    String text2 = line.getString();
                    boolean hadFormatting = false;
                    if (text2.indexOf(167) != -1) {
                        text2 = ChatFormatting.m_126649_((String)text2);
                        hadFormatting = true;
                    } else {
                        boolean bl = hadFormatting = !line.m_7383_().m_131179_();
                    }
                    if (hadFormatting && Objects.equals(text2, Platform.getModName(what.getModId()))) continue;
                    tooltipText.append('\n').append(text2);
                    continue;
                }
                if (i > 0) {
                    tooltipText.append('\n');
                }
                line.m_5651_(text -> {
                    if (text.indexOf(167) != -1) {
                        text = ChatFormatting.m_126649_((String)text);
                    }
                    tooltipText.append(text);
                    return Optional.empty();
                });
            }
            return tooltipText.toString();
        });
    }
}

