/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.search;

import appeng.api.stacks.AEKey;
import appeng.client.gui.me.search.RepoSearch;
import appeng.client.gui.me.search.TagPredicate;
import appeng.core.AEConfig;
import appeng.menu.me.common.GridInventoryEntry;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class SearchPredicates {
    SearchPredicates() {
    }

    static Predicate<GridInventoryEntry> fromString(String searchString, RepoSearch repoSearch) {
        if (searchString.startsWith("@")) {
            return SearchPredicates.createModIdPredicate(searchString.substring(1));
        }
        if (searchString.startsWith("*")) {
            return SearchPredicates.createIdPredicate(searchString.substring(1));
        }
        if (searchString.startsWith("#")) {
            Pattern pattern = SearchPredicates.createPattern(searchString.substring(1));
            return new TagPredicate(pattern);
        }
        Pattern pattern = SearchPredicates.createPattern(searchString);
        if (AEConfig.instance().isSearchTooltips()) {
            return SearchPredicates.createTooltipPredicate(pattern, repoSearch);
        }
        return SearchPredicates.createNamePredicate(pattern);
    }

    private static Predicate<GridInventoryEntry> createModIdPredicate(String searchText) {
        Pattern searchPattern = SearchPredicates.createPattern(searchText);
        return entry -> {
            AEKey what = Objects.requireNonNull(entry.getWhat());
            return searchPattern.matcher(what.getModId()).find();
        };
    }

    private static Predicate<GridInventoryEntry> createIdPredicate(String searchText) {
        Pattern searchPattern = SearchPredicates.createPattern(searchText);
        return entry -> {
            AEKey what = Objects.requireNonNull(entry.getWhat());
            return searchPattern.matcher(what.getId().toString()).find();
        };
    }

    private static Predicate<GridInventoryEntry> createNamePredicate(Pattern searchPattern) {
        return entry -> {
            AEKey what = Objects.requireNonNull(entry.getWhat());
            String displayName = what.getDisplayName().getString();
            return searchPattern.matcher(displayName).find();
        };
    }

    private static Predicate<GridInventoryEntry> createTooltipPredicate(Pattern searchPattern, RepoSearch repoSearch) {
        return entry -> {
            String tooltipText = repoSearch.getTooltipText(entry.getWhat());
            return searchPattern.matcher(tooltipText).find();
        };
    }

    private static Pattern createPattern(String searchText) {
        try {
            return Pattern.compile(searchText.toLowerCase(), 66);
        }
        catch (PatternSyntaxException ignored) {
            return Pattern.compile(Pattern.quote(searchText.toLowerCase()), 66);
        }
    }
}

