/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.spatial;

import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.spatial.SpatialPylonBakedModel;
import appeng.client.render.spatial.SpatialPylonTextureType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

public class SpatialPylonModel
implements BasicUnbakedModel<SpatialPylonModel> {
    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        EnumMap<SpatialPylonTextureType, TextureAtlasSprite> textures = new EnumMap<SpatialPylonTextureType, TextureAtlasSprite>(SpatialPylonTextureType.class);
        for (SpatialPylonTextureType type : SpatialPylonTextureType.values()) {
            textures.put(type, spriteGetter.apply(SpatialPylonModel.getTexturePath(type)));
        }
        return new SpatialPylonBakedModel(textures);
    }

    @Override
    public Stream<Material> getAdditionalTextures() {
        return Arrays.stream(SpatialPylonTextureType.values()).map(SpatialPylonModel::getTexturePath);
    }

    private static Material getTexturePath(SpatialPylonTextureType type) {
        return new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2", "block/spatial_pylon/" + type.name().toLowerCase(Locale.ROOT)));
    }
}

