/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.blockentity.misc.SkyCompassBlockEntity;
import appeng.client.render.BakedModelUnwrapper;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.SkyCompassBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkyCompassTESR
implements BlockEntityRenderer<SkyCompassBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public SkyCompassTESR(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(SkyCompassBlockEntity te, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockState = te.m_58900_();
        BakedModel model = this.blockRenderer.m_110907_().m_110893_(blockState);
        SkyCompassBakedModel skyCompassModel = BakedModelUnwrapper.unwrap(model, SkyCompassBakedModel.class);
        if (skyCompassModel == null) {
            return;
        }
        BakedModel pointerModel = skyCompassModel.getPointer();
        Direction forward = te.getForward();
        Direction up = te.getUp();
        if (forward == Direction.UP || forward == Direction.DOWN) {
            up = Direction.NORTH;
        }
        poseStack.m_85836_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110451_());
        float rotation = SkyCompassTESR.getRotation(te);
        poseStack.m_85837_(0.5, 0.5, 0.5);
        FacingToRotation.get(up, forward).push(poseStack);
        poseStack.m_85845_(new Quaternion(0.0f, rotation, 0.0f, false));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        ModelBlockRenderer modelRenderer = this.blockRenderer.m_110937_();
        modelRenderer.m_111067_(poseStack.m_85850_(), buffer, null, pointerModel, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn);
        poseStack.m_85849_();
    }

    private static float getRotation(SkyCompassBlockEntity skyCompass) {
        float rotation = skyCompass.getForward() == Direction.UP || skyCompass.getForward() == Direction.DOWN ? SkyCompassBakedModel.getAnimatedRotation(skyCompass.m_58899_(), false) : SkyCompassBakedModel.getAnimatedRotation(null, false);
        if (skyCompass.getForward() == Direction.DOWN) {
            rotation = SkyCompassTESR.flipidiy(rotation);
        }
        return rotation;
    }

    private static float flipidiy(float rad) {
        float x = (float)Math.cos(rad);
        float y = (float)Math.sin(rad);
        return (float)Math.atan2(-y, x);
    }
}

