/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.models;

import appeng.core.AppEng;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class AE2BlockStateProvider
extends BlockStateProvider
implements IAE2DataProvider {
    public AE2BlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void simpleBlockAndItem(BlockDefinition<?> block) {
        ModelFile model = this.cubeAll((Block)block.block());
        this.simpleBlock((Block)block.block(), model);
        this.simpleBlockItem((Block)block.block(), model);
    }

    protected void simpleBlockAndItem(BlockDefinition<?> block, ModelFile model) {
        this.simpleBlock((Block)block.block(), model);
        this.simpleBlockItem((Block)block.block(), model);
    }

    protected void simpleBlockAndItem(BlockDefinition<?> block, String textureName) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(block.id().m_135815_(), AppEng.makeId(textureName));
        this.simpleBlock((Block)block.block(), (ModelFile)model);
        this.simpleBlockItem((Block)block.block(), (ModelFile)model);
    }

    protected void wall(BlockDefinition<WallBlock> block, String texture) {
        this.wallBlock(block.block(), AppEng.makeId(texture));
        this.itemModels().wallInventory(block.id().m_135815_(), AppEng.makeId(texture));
    }

    protected void slabBlock(BlockDefinition<SlabBlock> slab, BlockDefinition<?> base) {
        String texture = this.blockTexture((Block)base.block()).m_135815_();
        this.slabBlock(slab, base, texture, texture, texture);
    }

    protected void slabBlock(BlockDefinition<SlabBlock> slab, BlockDefinition<?> base, String bottomTexture, String sideTexture, String topTexture) {
        ResourceLocation side = AppEng.makeId(sideTexture);
        ResourceLocation bottom = AppEng.makeId(bottomTexture);
        ResourceLocation top = AppEng.makeId(topTexture);
        BlockModelBuilder bottomModel = (BlockModelBuilder)this.models().slab(slab.id().m_135815_(), side, bottom, top);
        this.simpleBlockItem((Block)slab.block(), (ModelFile)bottomModel);
        this.slabBlock(slab.block(), (ModelFile)bottomModel, (ModelFile)this.models().slabTop(slab.id().m_135815_() + "_top", side, bottom, top), (ModelFile)this.models().getExistingFile(base.id()));
    }

    protected void stairsBlock(BlockDefinition<StairBlock> stairs, BlockDefinition<?> base) {
        String texture = "block/" + base.id().m_135815_();
        this.stairsBlock(stairs, texture, texture, texture);
    }

    protected void stairsBlock(BlockDefinition<StairBlock> stairs, String bottomTexture, String sideTexture, String topTexture) {
        String baseName = stairs.id().m_135815_();
        ResourceLocation side = AppEng.makeId(sideTexture);
        ResourceLocation bottom = AppEng.makeId(bottomTexture);
        ResourceLocation top = AppEng.makeId(topTexture);
        ModelBuilder stairsModel = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock(stairs.block(), (ModelFile)stairsModel, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem((Block)stairs.block(), (ModelFile)stairsModel);
    }
}

