/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEEntities;
import appeng.core.sync.packets.MockExplosionPacket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public final class TinyTNTPrimedEntity
extends PrimedTnt
implements IEntityAdditionalSpawnData {
    private LivingEntity placedBy;

    public TinyTNTPrimedEntity(EntityType<? extends TinyTNTPrimedEntity> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public TinyTNTPrimedEntity(Level level, double x, double y, double z, LivingEntity igniter) {
        super(AEEntities.TINY_TNT_PRIMED, level);
        this.m_6034_(x, y, z);
        double d0 = level.f_46441_.nextDouble() * 6.2831854820251465;
        this.m_20334_(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.m_32085_(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.placedBy = igniter;
    }

    @Nullable
    public LivingEntity m_32099_() {
        return this.placedBy;
    }

    public void m_8119_() {
        this.m_20073_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.m_20256_(this.m_20184_().m_82492_(0.0, (double)0.04f, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82542_((double)0.98f, (double)0.98f, (double)0.98f));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_((double)0.7f, (double)0.7f, -0.5));
        }
        if (this.m_20069_() && !this.f_19853_.m_5776_()) {
            ItemStack tntStack = AEBlocks.TINY_TNT.stack();
            ItemEntity item = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), tntStack);
            item.m_20256_(this.m_20184_());
            item.f_19854_ = this.f_19854_;
            item.f_19855_ = this.f_19855_;
            item.f_19856_ = this.f_19856_;
            this.f_19853_.m_7967_((Entity)item);
            this.m_146870_();
        }
        if (this.m_32100_() <= 0) {
            this.m_146870_();
            if (!this.f_19853_.f_46443_) {
                this.m_32103_();
            }
        } else {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        this.m_32085_(this.m_32100_() - 1);
    }

    protected void m_32103_() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_19853_.f_46441_.nextFloat() - this.f_19853_.f_46441_.nextFloat()) * 0.2f) * 32.9f);
        if (this.m_20069_()) {
            return;
        }
        Explosion ex = new Explosion(this.f_19853_, (Entity)this, null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.2f, false, Explosion.BlockInteraction.BREAK);
        AABB area = new AABB(this.m_20185_() - 1.5, this.m_20186_() - 1.5, this.m_20189_() - 1.5, this.m_20185_() + 1.5, this.m_20186_() + 1.5, this.m_20189_() + 1.5);
        List list = this.f_19853_.m_45933_((Entity)this, area);
        ForgeEventFactory.onExplosionDetonate((Level)this.f_19853_, (Explosion)ex, (List)list, (double)0.4f);
        for (Entity e : list) {
            e.m_6469_(DamageSource.m_19358_((Explosion)ex), 6.0f);
        }
        if (AEConfig.instance().isTinyTntBlockDamageEnabled()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() - 0.25, this.m_20189_());
            int x = (int)(this.m_20185_() - 2.0);
            while ((double)x <= this.m_20185_() + 2.0) {
                int y = (int)(this.m_20186_() - 2.0);
                while ((double)y <= this.m_20186_() + 2.0) {
                    int z = (int)(this.m_20189_() - 2.0);
                    while ((double)z <= this.m_20189_() + 2.0) {
                        BlockPos point = new BlockPos(x, y, z);
                        BlockState state = this.f_19853_.m_8055_(point);
                        Block block = state.m_60734_();
                        if (!state.m_60795_()) {
                            float strength = (float)((double)2.3f - (((double)((float)x + 0.5f) - this.m_20185_()) * ((double)((float)x + 0.5f) - this.m_20185_()) + ((double)((float)y + 0.5f) - this.m_20186_()) * ((double)((float)y + 0.5f) - this.m_20186_()) + ((double)((float)z + 0.5f) - this.m_20189_()) * ((double)((float)z + 0.5f) - this.m_20189_())));
                            float fluidResistance = !state.m_60819_().m_76178_() ? state.m_60819_().m_76190_() : 0.0f;
                            float resistance = Math.max(block.getExplosionResistance(state, (BlockGetter)this.f_19853_, point, ex), fluidResistance);
                            if ((double)(strength -= (resistance + 0.3f) * 0.11f) > 0.01 && state.m_60767_() != Material.f_76296_) {
                                if (block.m_6903_(ex)) {
                                    Block.m_49950_((BlockState)state, (Level)this.f_19853_, (BlockPos)point);
                                }
                                this.f_19853_.m_7731_(point, Blocks.f_50016_.m_49966_(), 3);
                                state.onBlockExploded(this.f_19853_, point, ex);
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        AppEng.instance().sendToAllNearExcept(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.f_19853_, new MockExplosionPacket(this.m_20185_(), this.m_20186_(), this.m_20189_()));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.m_32100_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_32085_(additionalData.readByte());
    }
}

