/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.items.parts.FacadeItem;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

class FacadeRegistryPlugin
implements IRecipeManagerPlugin {
    private final FacadeItem itemFacade;
    private final ItemStack cableAnchor;

    FacadeRegistryPlugin(FacadeItem itemFacade, ItemStack cableAnchor) {
        this.itemFacade = itemFacade;
        this.cableAnchor = cableAnchor;
    }

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        ItemStack stackFocus = focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        if (focus.getRole() == RecipeIngredientRole.OUTPUT && stackFocus != null ? stackFocus.m_41720_() instanceof FacadeItem : focus.getRole() == RecipeIngredientRole.INPUT && stackFocus != null && !this.itemFacade.createFacadeForItem(stackFocus, true).m_41619_()) {
            return Collections.singletonList(RecipeTypes.CRAFTING);
        }
        return Collections.emptyList();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        ItemStack facade;
        if (!RecipeTypes.CRAFTING.equals((Object)recipeCategory.getRecipeType())) {
            return Collections.emptyList();
        }
        ItemStack focusStack = focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        if (focus.getRole() == RecipeIngredientRole.OUTPUT && focusStack != null) {
            Item item = focusStack.m_41720_();
            if (item instanceof FacadeItem) {
                FacadeItem facadeItem = (FacadeItem)item;
                ItemStack textureItem = facadeItem.getTextureItem(focusStack);
                return Collections.singletonList(this.make(textureItem, this.cableAnchor, focusStack));
            }
        } else if (focus.getRole() == RecipeIngredientRole.INPUT && focusStack != null && !(facade = this.itemFacade.createFacadeForItem(focusStack, false)).m_41619_()) {
            return Collections.singletonList(this.make(focusStack, this.cableAnchor, facade));
        }
        return Collections.emptyList();
    }

    private ShapedRecipe make(ItemStack textureItem, ItemStack cableAnchor, ItemStack result) {
        ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)textureItem.m_41720_());
        ResourceLocation id = new ResourceLocation("ae2", "facade/" + itemId.m_135827_() + "/" + itemId.m_135815_());
        NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        ingredients.set(1, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(3, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(5, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(7, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(4, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{textureItem}));
        ItemStack output = result.m_41777_();
        output.m_41764_(4);
        return new ShapedRecipe(id, "", 3, 3, ingredients, output);
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }

    public <V> List<ResourceLocation> getRecipeCategoryUids(IFocus<V> focus) {
        return this.getRecipeTypes(focus).stream().map(RecipeType::getUid).toList();
    }
}

