/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.exceptions.SecurityConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AEColor;
import appeng.core.AELog;
import appeng.hooks.ticking.TickHandler;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;

public class InWorldGridNode
extends GridNode {
    private final BlockPos location;

    public <T> InWorldGridNode(ServerLevel level, BlockPos location, T owner, IGridNodeListener<T> listener, Set<GridFlags> flags) {
        super(level, owner, listener, flags);
        this.location = location;
    }

    @Override
    protected void findInWorldConnections() {
        GridNode adjacentNode;
        EnumSet<Direction> newSecurityConnections = EnumSet.noneOf(Direction.class);
        this.cleanupConnections();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (Direction direction : this.exposedOnSides) {
            pos.m_122159_((Vec3i)this.location, direction);
            adjacentNode = (GridNode)GridHelper.getExposedNode((LevelAccessor)this.getLevel(), (BlockPos)pos, direction.m_122424_());
            if (adjacentNode == null || !this.hasCompatibleColor(adjacentNode)) continue;
            for (GridConnection c : this.connections) {
                if (!c.isInWorld() || c.getDirection(this) != direction) continue;
                IGridNode os = c.getOtherSide(this);
                if (os == adjacentNode) continue block0;
                AELog.warn("Grid node %s did not disconnect properly and is now replaced with %s", os, adjacentNode);
                c.destroy();
                break;
            }
            if (adjacentNode.getLastSecurityKey() != -1L) {
                newSecurityConnections.add(direction);
                continue;
            }
            if (this.connectTo(direction, adjacentNode)) continue;
            return;
        }
        for (Direction direction : newSecurityConnections) {
            pos.m_122159_((Vec3i)this.location, direction);
            adjacentNode = (GridNode)GridHelper.getExposedNode((LevelAccessor)this.getLevel(), (BlockPos)pos, direction.m_122424_());
            if (adjacentNode == null || this.connectTo(direction, adjacentNode)) continue;
            return;
        }
    }

    @Override
    public String toString() {
        return super.toString() + " @ " + this.location.m_123341_() + "," + this.location.m_123342_() + "," + this.location.m_123343_();
    }

    private void cleanupConnections() {
        for (IGridConnection connection : this.getConnections()) {
            if (!connection.isInWorld()) continue;
            Direction ourSide = connection.getDirection(this);
            if (!this.isExposedOnSide(ourSide)) {
                connection.destroy();
                continue;
            }
            Direction theirSide = ourSide.m_122424_();
            IGridNode otherNode = connection.getOtherSide(this);
            if (otherNode.isExposedOnSide(theirSide) && this.hasCompatibleColor(otherNode)) continue;
            connection.destroy();
        }
    }

    private boolean hasCompatibleColor(IGridNode otherNode) {
        AEColor ourColor = this.getGridColor();
        AEColor theirColor = otherNode.getGridColor();
        return ourColor == AEColor.TRANSPARENT || theirColor == AEColor.TRANSPARENT || ourColor == theirColor;
    }

    private boolean connectTo(Direction direction, IGridNode adjacentNode) {
        try {
            GridConnection.create(adjacentNode, this, direction.m_122424_());
            return true;
        }
        catch (SecurityConnectionException e) {
            AELog.debug(e);
            TickHandler.instance().addCallable((LevelAccessor)adjacentNode.getLevel(), () -> this.callListener(IGridNodeListener::onSecurityBreak));
            return false;
        }
        catch (FailedConnectionException e) {
            AELog.debug(e);
            return false;
        }
    }

    public BlockPos getLocation() {
        return this.location;
    }
}

