/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IStorageMonitorPart;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.render.BlockEntityRenderHelper;
import appeng.core.localization.PlayerMessages;
import appeng.menu.me.interaction.StackInteractions;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.util.Platform;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractMonitorPart
extends AbstractDisplayPart
implements IStorageMonitorPart,
IStorageWatcherNode {
    @Nullable
    private AEKey configuredItem;
    private long amount;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;

    public AbstractMonitorPart(IPartItem<?> partItem, boolean requireChannel) {
        super(partItem, requireChannel);
        this.getMainNode().addService(IStorageWatcherNode.class, this);
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.isLocked = data.m_128471_("isLocked");
        this.configuredItem = AEKey.fromTagGeneric(data.m_128469_("configuredItem"));
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128379_("isLocked", this.isLocked);
        if (this.configuredItem != null) {
            data.m_128365_("configuredItem", (Tag)this.configuredItem.toTagGeneric());
        }
    }

    @Override
    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            AEKey.writeKey(data, this.configuredItem);
            data.m_130103_(this.amount);
        }
    }

    @Override
    public boolean readFromStream(FriendlyByteBuf data) {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw |= this.isLocked != isLocked;
        this.isLocked = isLocked;
        if (data.readBoolean()) {
            this.configuredItem = AEKey.readKey(data);
            this.amount = data.m_130258_();
        } else {
            this.configuredItem = null;
            this.amount = 0L;
        }
        return needRedraw;
    }

    @Override
    public void writeVisualStateToNBT(CompoundTag data) {
        super.writeVisualStateToNBT(data);
        data.m_128356_("amount", this.amount);
    }

    @Override
    public void readVisualStateFromNBT(CompoundTag data) {
        super.readVisualStateFromNBT(data);
        this.amount = data.m_128454_("amount");
    }

    @Override
    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (this.isClientSide()) {
            return true;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getHost().getLocation(), player)) {
            return false;
        }
        if (!this.isLocked) {
            ItemStack eq = player.m_21120_(hand);
            if (AEItemKey.matches(this.configuredItem, eq)) {
                GenericStack containedStack = StackInteractions.getContainedStack(eq);
                if (containedStack != null) {
                    this.configuredItem = containedStack.what();
                }
            } else {
                this.configuredItem = AEItemKey.of(eq);
            }
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        this.configureWatchers();
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    @Override
    public boolean onPartShiftActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (this.isClientSide()) {
            return true;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getHost().getLocation(), player)) {
            return false;
        }
        if (player.m_21120_(hand).m_41619_()) {
            this.isLocked = !this.isLocked;
            player.m_6352_((Component)(this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).text(), Util.f_137441_);
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        if (this.configuredItem != null) {
            if (this.myWatcher != null) {
                this.myWatcher.add(this.configuredItem);
            }
            this.getMainNode().ifPresent(grid -> this.updateReportingValue(grid.getStorageService()));
        }
    }

    private void updateReportingValue(IStorageService storageService) {
        this.lastHumanReadableText = null;
        this.amount = this.configuredItem != null ? storageService.getCachedInventory().get(this.configuredItem) : 0L;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        if (!this.isActive()) {
            return;
        }
        if (this.configuredItem == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        BlockEntityRenderHelper.rotateToFace(poseStack, this.getSide(), this.getSpin());
        poseStack.m_85837_(0.0, 0.05, 0.5);
        BlockEntityRenderHelper.renderItem2dWithAmount(poseStack, buffers, this.getDisplayed(), this.amount, 0.4f, -0.23f, this.getColor().contrastTextColor);
        poseStack.m_85849_();
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @Override
    @Nullable
    public AEKey getDisplayed() {
        return this.configuredItem;
    }

    public void setConfiguredItem(@Nullable AEKey configuredItem) {
        this.configuredItem = configuredItem;
        this.getHost().markForUpdate();
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
        this.getHost().markForUpdate();
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(AEKey what, long amount) {
        if (what.equals(this.configuredItem)) {
            this.amount = amount;
            String humanReadableText = what.formatAmount(amount, AmountFormat.PREVIEW_REGULAR);
            if (!humanReadableText.equals(this.lastHumanReadableText)) {
                this.lastHumanReadableText = humanReadableText;
                this.getHost().markForUpdate();
            }
        }
    }

    @Override
    public boolean showNetworkInfo(UseOnContext context) {
        return false;
    }

    protected IPartModel selectModel(IPartModel off, IPartModel on, IPartModel hasChannel, IPartModel lockedOff, IPartModel lockedOn, IPartModel lockedHasChannel) {
        if (this.isActive()) {
            if (this.isLocked()) {
                return lockedHasChannel;
            }
            return hasChannel;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return lockedOn;
            }
            return on;
        }
        if (this.isLocked()) {
            return lockedOff;
        }
        return off;
    }
}

