/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.Actionable;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.storage.CreativeCellItem;
import appeng.me.helpers.BaseActionSource;
import appeng.menu.AutoCraftingMenu;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class AutoCraftingTestPlot {
    private AutoCraftingTestPlot() {
    }

    @TestPlot(value="autocrafting_testplot")
    public static void create(PlotBuilder plot) {
        plot.creativeEnergyCell("4 -1 4");
        plot.cable("4 0 [1,5]");
        plot.cable("[3,6] 0 1");
        plot.block("[4,5] [0,1] [4,5]", AEBlocks.CONTROLLER);
        AutoCraftingTestPlot.craftingCube(plot.offset(1, 0, 1));
        plot.cable("[6,8] 0 5");
        PlotBuilder assemblerStack = plot.offset(8, 1, 5);
        for (int i = 0; i < 8; ++i) {
            AutoCraftingTestPlot.assemblerFlower(assemblerStack.offset(0, i * 3, 0));
        }
        plot.blockEntity("7 0 1", AEBlocks.DRIVE, drive -> {
            drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.FLUID_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.FLUID_CELL_64K.stack());
            drive.getInternalInventory().addItems(CreativeCellItem.ofItems(new ItemLike[]{Items.f_42451_}));
            drive.getInternalInventory().addItems(CreativeCellItem.ofFluids(new Fluid[]{Fluids.f_76195_}));
        });
        plot.part("6 0 1", Direction.NORTH, AEParts.PATTERN_ENCODING_TERMINAL, term -> {
            InternalInventory inv = term.getLogic().getBlankPatternInv();
            inv.addItems(AEItems.BLANK_PATTERN.stack(64));
        });
        plot.part("5 0 1", Direction.NORTH, AEParts.PATTERN_ACCESS_TERMINAL);
        plot.part("4 0 1", Direction.NORTH, AEParts.TERMINAL);
        plot.part("3 0 1", Direction.NORTH, AEParts.CRAFTING_TERMINAL);
        AutoCraftingTestPlot.buildObsidianCrafting(plot.offset(3, 0, 5));
        AutoCraftingTestPlot.buildChestCraftingExport(plot.offset(5, 0, 7));
        AutoCraftingTestPlot.buildWaterEmittingSource(plot.offset(5, 0, 9));
        plot.cable("4 0 [6,9]", AEParts.SMART_DENSE_CABLE);
        plot.afterGridInitAt("4 0 4", (grid, gridNode) -> {
            ServerLevel level = gridNode.getLevel();
            ArrayList<ItemStack> patterns = new ArrayList<ItemStack>();
            patterns.add(AutoCraftingTestPlot.encodeCraftingPattern(level, new Object[]{Items.f_42647_, Items.f_42647_, null, Items.f_42647_, Items.f_42797_, null, null, null, null}, true, false));
            patterns.add(AutoCraftingTestPlot.encodeCraftingPattern(level, new Object[]{Items.f_42647_, Items.f_42647_, Items.f_42647_, Items.f_42647_, null, Items.f_42647_, Items.f_42797_, Items.f_42647_, Items.f_42647_}, true, false));
            patterns.add(PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76193_), 1000L), GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42451_))}, new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76193_), 1000L)}));
            MEStorage networkInv = grid.getStorageService().getInventory();
            networkInv.insert(AEItemKey.of((ItemLike)Items.f_42647_), 83L, Actionable.MODULATE, new BaseActionSource());
            block0: for (PatternProviderBlockEntity provider : grid.getMachines(PatternProviderBlockEntity.class)) {
                while (!patterns.isEmpty()) {
                    ItemStack pattern = (ItemStack)patterns.get(0);
                    if (!provider.getLogic().getPatternInv().addItems(pattern).m_41619_()) continue block0;
                    patterns.remove(0);
                }
            }
        });
    }

    private static void buildChestCraftingExport(PlotBuilder plot) {
        plot.cable("0 0 0").part(Direction.SOUTH, AEParts.EXPORT_BUS, eb -> {
            eb.getUpgrades().addItems(new ItemStack(AEItems.CRAFTING_CARD));
            eb.getConfig().insert(0, AEItemKey.of((ItemLike)Items.f_42009_), 1L, Actionable.MODULATE);
        });
        plot.block("0 0 1", Blocks.f_50087_);
    }

    private static void buildWaterEmittingSource(PlotBuilder plot) {
        plot.cable("0 0 0").part(Direction.SOUTH, AEParts.QUARTZ_FIBER);
        plot.cable("0 0 1").part(Direction.NORTH, AEParts.TOGGLE_BUS);
        plot.cable("0 1 0");
        plot.cable("0 1 1").craftingEmitter(Direction.DOWN, (Fluid)Fluids.f_76193_).part(Direction.SOUTH, AEParts.INTERFACE);
        plot.cable("0 1 2").part(Direction.NORTH, AEParts.STORAGE_BUS, storageBus -> storageBus.getConfig().insert(0, AEFluidKey.of((Fluid)Fluids.f_76193_), 1L, Actionable.MODULATE));
        plot.cable("0 0 2").part(Direction.DOWN, AEParts.ANNIHILATION_PLANE);
        plot.block("[-1,1] -1 2", Blocks.f_49990_);
    }

    private static void buildObsidianCrafting(PlotBuilder plot) {
        plot.blockEntity("0 0 0", AEBlocks.PATTERN_PROVIDER, provider -> {
            ItemStack pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76195_), 1000L)}, new GenericStack[]{new GenericStack(AEItemKey.of((ItemLike)Items.f_41999_), 1L)});
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        plot.cable("-1 0 0").part(Direction.EAST, AEParts.INTERFACE).part(Direction.WEST, AEParts.FORMATION_PLANE, plane -> plane.getConfig().insert(0, AEFluidKey.of((Fluid)Fluids.f_76195_), 1L, Actionable.MODULATE));
        plot.cable("-2 1 0").part(Direction.DOWN, AEParts.ANNIHILATION_PLANE);
        plot.cable("-1 1 0").part(Direction.DOWN, AEParts.QUARTZ_FIBER);
        plot.cable("0 1 0").part(Direction.DOWN, AEParts.STORAGE_BUS, part -> part.getConfig().insert(0, AEItemKey.of((ItemLike)Items.f_41999_), 1L, Actionable.MODULATE)).part(Direction.EAST, AEParts.QUARTZ_FIBER);
        plot.block("-3 0 [-2,0]", Blocks.f_50652_);
        plot.block("-1 0 [-2,-1]", Blocks.f_50652_);
        plot.block("-2 0 1", Blocks.f_50652_);
        plot.block("-2 0 -2", Blocks.f_49990_);
    }

    private static ItemStack encodeCraftingPattern(ServerLevel level, Object[] ingredients, boolean allowSubstitutions, boolean allowFluidSubstitutions) {
        ItemStack[] stacks = (ItemStack[])Arrays.stream(ingredients).map(in -> {
            if (in instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)in;
                return new ItemStack(itemLike);
            }
            if (in instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)in;
                return itemStack;
            }
            if (in == null) {
                return ItemStack.f_41583_;
            }
            throw new IllegalArgumentException("Unsupported argument: " + in);
        }).toArray(ItemStack[]::new);
        CraftingContainer c = new CraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
        for (int i = 0; i < stacks.length; ++i) {
            c.m_6836_(i, stacks[i]);
        }
        CraftingRecipe recipe = (CraftingRecipe)level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)c, (Level)level).orElseThrow();
        ItemStack result = recipe.m_5874_((Container)c);
        return PatternDetailsHelper.encodeCraftingPattern(recipe, stacks, result, allowSubstitutions, allowFluidSubstitutions);
    }

    private static void craftingCube(PlotBuilder plot) {
        plot.block("[-1,1] [0,2] [-1,1]", AEBlocks.CRAFTING_STORAGE_64K);
        plot.block("-1 2 -1", AEBlocks.CRAFTING_STORAGE_16K);
        plot.block("1 2 -1", AEBlocks.CRAFTING_STORAGE_4K);
        plot.block("-1 2 1", AEBlocks.CRAFTING_STORAGE_1K);
        plot.block("[-1,1] 0 [-1,1]", AEBlocks.CRAFTING_ACCELERATOR);
        plot.block("0 1 -1", AEBlocks.CRAFTING_MONITOR);
    }

    private static void assemblerFlower(PlotBuilder plot) {
        plot.block("0 0 0", AEBlocks.PATTERN_PROVIDER);
        plot.block("-1 0 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("1 0 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 0 1", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 0 -1", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 -1 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 1 0", AEBlocks.MOLECULAR_ASSEMBLER);
    }
}

