/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.core.AppEng;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.fallout.Fallout;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import com.google.common.math.StatsAccumulator;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class MeteoriteStructure
extends StructureFeature<NoneFeatureConfiguration> {
    public static final ResourceLocation ID = AppEng.makeId("meteorite");
    public static final ResourceKey<StructureSet> STRUCTURE_SET_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)ID);
    public static final ResourceKey<ConfiguredStructureFeature<?, ?>> KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)ID);
    public static final StructureFeature<NoneFeatureConfiguration> INSTANCE = new MeteoriteStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final TagKey<Biome> BIOME_TAG_KEY = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)AppEng.makeId("has_meteorites"));
    public static Holder<ConfiguredStructureFeature<?, ?>> CONFIGURED_INSTANCE;

    public MeteoriteStructure(Codec<NoneFeatureConfiguration> configCodec) {
        super(configCodec, PieceGeneratorSupplier.m_197349_(MeteoriteStructure::checkLocation, MeteoriteStructure::generatePieces));
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        if (!context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG)) {
            return false;
        }
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        return worldgenRandom.nextBoolean();
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        ChunkPos chunkPos = context.f_192705_();
        WorldgenRandom random = context.f_192708_();
        LevelHeightAccessor heightAccessor = context.f_192707_();
        ChunkGenerator generator = context.f_192703_();
        int centerX = chunkPos.m_45604_() + random.nextInt(16);
        int centerZ = chunkPos.m_45605_() + random.nextInt(16);
        float meteoriteRadius = random.nextFloat() * 6.0f + 2.0f;
        int yOffset = (int)Math.ceil(meteoriteRadius) + 1;
        Set t2 = generator.m_62218_().m_183399_(centerX, generator.m_6337_(), centerZ, 0, generator.m_183403_());
        Holder spawnBiome = (Holder)t2.stream().findFirst().orElseThrow();
        boolean isOcean = Biome.m_204183_((Holder)spawnBiome) == Biome.BiomeCategory.OCEAN;
        Heightmap.Types heightmapType = isOcean ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        StatsAccumulator stats = new StatsAccumulator();
        int scanRadius = (int)Math.max(1.0f, meteoriteRadius * 2.0f);
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                int h = generator.m_142647_(centerX + x, centerZ + z, heightmapType, heightAccessor);
                stats.add((double)h);
            }
        }
        int centerY = (int)stats.mean();
        if (stats.populationVariance() > 5.0) {
            centerY = (int)((double)centerY - (stats.mean() - stats.min()) * 0.75);
        }
        centerY -= yOffset;
        centerY = Math.max(heightAccessor.m_141937_() + yOffset, centerY);
        BlockPos actualPos = new BlockPos(centerX, centerY, centerZ);
        boolean craterLake = MeteoriteStructure.locateWaterAroundTheCrater(actualPos, meteoriteRadius, context);
        CraterType craterType = MeteoriteStructure.determineCraterType((Holder<Biome>)spawnBiome, (Random)random);
        boolean pureCrater = random.nextFloat() > 0.9f;
        FalloutMode fallout = Fallout.fromBiome((Holder<Biome>)spawnBiome);
        piecesBuilder.m_142679_((StructurePiece)new MeteoriteStructurePiece(actualPos, meteoriteRadius, craterType, fallout, pureCrater, craterLake));
    }

    private static boolean locateWaterAroundTheCrater(BlockPos pos, float radius, PieceGenerator.Context<?> context) {
        ChunkGenerator generator = context.f_192703_();
        LevelHeightAccessor heightAccessor = context.f_192707_();
        int seaLevel = generator.m_6337_();
        int maxY = seaLevel - 1;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        blockPos.m_142448_(maxY);
        for (int i = pos.m_123341_() - 32; i <= pos.m_123341_() + 32; ++i) {
            blockPos.m_142451_(i);
            for (int k = pos.m_123343_() - 32; k <= pos.m_123343_() + 32; ++k) {
                int heigth;
                blockPos.m_142443_(k);
                double dx = i - pos.m_123341_();
                double dz = k - pos.m_123343_();
                double h = (float)pos.m_123342_() - radius + 1.0f;
                double distanceFrom = dx * dx + dz * dz;
                if (!((double)maxY > h + distanceFrom * 0.0175) || !((double)maxY < h + distanceFrom * 0.02) || (heigth = generator.m_142647_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR, heightAccessor)) >= seaLevel) continue;
                return true;
            }
        }
        return false;
    }

    private static CraterType determineCraterType(Holder<Biome> biomeHolder, Random random) {
        boolean lava;
        boolean lake;
        boolean specialMeteor;
        Biome biome = (Biome)biomeHolder.m_203334_();
        float temp = biome.m_47554_();
        Biome.BiomeCategory category = Biome.m_204183_(biomeHolder);
        if (category == Biome.BiomeCategory.OCEAN) {
            return CraterType.NONE;
        }
        boolean bl = specialMeteor = random.nextFloat() > 0.5f;
        if (!specialMeteor) {
            return CraterType.NORMAL;
        }
        if (temp >= 1.0f) {
            boolean lava2 = random.nextFloat() > 0.5f;
            switch (biome.m_47530_()) {
                case NONE: {
                    return lava2 ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    boolean obsidian = random.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    return lava2 ? alternativObsidian : CraterType.NORMAL;
                }
            }
        }
        if (temp < 1.0f && (double)temp >= 0.2) {
            lake = random.nextFloat() > 0.25f;
            lava = random.nextFloat() > 0.8f;
            switch (biome.m_47530_()) {
                case NONE: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    boolean obsidian = random.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    CraterType craterLake = lake ? CraterType.WATER : CraterType.NORMAL;
                    return lava ? alternativObsidian : craterLake;
                }
                case SNOW: {
                    boolean snow = random.nextFloat() > 0.75f;
                    CraterType water = lake ? CraterType.WATER : CraterType.NORMAL;
                    return snow ? CraterType.SNOW : water;
                }
            }
        }
        if ((double)temp < 0.2) {
            lake = random.nextFloat() > 0.25f;
            lava = random.nextFloat() > 0.95f;
            boolean frozen = random.nextFloat() > 0.25f;
            switch (biome.m_47530_()) {
                case NONE: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    CraterType frozenLake = frozen ? CraterType.ICE : CraterType.WATER;
                    CraterType craterLake = lake ? frozenLake : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : craterLake;
                }
                case SNOW: {
                    CraterType snowCovered = lake ? CraterType.SNOW : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : snowCovered;
                }
            }
        }
        return CraterType.NORMAL;
    }
}

