/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacksvh.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3d;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import org.jetbrains.annotations.Nullable;

public class BackpackArmorOffsetsManager {
    private static final Map<Item, Vector3d> BACKPACK_DEFAULT_TRANSLATIONS = new HashMap<Item, Vector3d>();
    private static final Map<Item, Map<Item, Vector3d>> BACKPACK_ARMOR_TRANSLATIONS = new HashMap<Item, Map<Item, Vector3d>>();

    public static Optional<Vector3d> getOffsets(Item backpackItem, Item armorItem) {
        Map<Item, Vector3d> armorTranslations;
        if (BACKPACK_ARMOR_TRANSLATIONS.containsKey(backpackItem) && (armorTranslations = BACKPACK_ARMOR_TRANSLATIONS.get(backpackItem)).containsKey(armorItem)) {
            return Optional.of(armorTranslations.get(armorItem));
        }
        if (BACKPACK_DEFAULT_TRANSLATIONS.containsKey(backpackItem)) {
            return Optional.of(BACKPACK_DEFAULT_TRANSLATIONS.get(backpackItem));
        }
        return Optional.empty();
    }

    public static class Loader
    implements IRegistryDataLoader {
        public String getName() {
            return "armor_offsets";
        }

        public void parse(JsonObject json, @Nullable String modId) {
            for (Map.Entry property : json.entrySet()) {
                RegistryHelper.getItemFromName((String)((String)property.getKey())).ifPresent(backpackItem -> this.parseBackpackOffsets(property, (Item)backpackItem));
            }
        }

        private void parseBackpackOffsets(Map.Entry<String, JsonElement> property, Item backpackItem) {
            if (property.getValue().isJsonObject()) {
                JsonElement ovs;
                JsonElement defOffs;
                JsonObject settings = property.getValue().getAsJsonObject();
                if (settings.has("default") && (defOffs = settings.get("default")).isJsonObject()) {
                    BACKPACK_DEFAULT_TRANSLATIONS.put(backpackItem, this.getOffsets(defOffs.getAsJsonObject()));
                }
                if (settings.has("overrides") && (ovs = settings.get("overrides")).isJsonArray()) {
                    for (JsonElement override : ovs.getAsJsonArray()) {
                        if (!override.isJsonObject()) continue;
                        this.parseOverride(backpackItem, override.getAsJsonObject());
                    }
                }
            }
        }

        private void parseOverride(Item backpackItem, JsonObject overrideJson) {
            JsonElement offsetsJson;
            if (overrideJson.has("offsets") && (offsetsJson = overrideJson.get("offsets")).isJsonObject()) {
                Vector3d offsets = this.getOffsets(offsetsJson.getAsJsonObject());
                if (overrideJson.has("armor")) {
                    JsonElement armorJson = overrideJson.get("armor");
                    if (armorJson.isJsonPrimitive()) {
                        RegistryHelper.getItemFromName((String)armorJson.getAsString()).ifPresent(armorItem -> BACKPACK_ARMOR_TRANSLATIONS.computeIfAbsent(backpackItem, bi -> new HashMap()).put(armorItem, offsets));
                    } else if (armorJson.isJsonArray()) {
                        for (JsonElement armor : armorJson.getAsJsonArray()) {
                            if (!armor.isJsonPrimitive()) continue;
                            RegistryHelper.getItemFromName((String)armor.getAsString()).ifPresent(armorItem -> BACKPACK_ARMOR_TRANSLATIONS.computeIfAbsent(backpackItem, bi -> new HashMap()).put(armorItem, offsets));
                        }
                    }
                }
            }
        }

        private Vector3d getOffsets(JsonObject offsetsJson) {
            return new Vector3d(GsonHelper.m_144742_((JsonObject)offsetsJson, (String)"x", (double)0.0), GsonHelper.m_144742_((JsonObject)offsetsJson, (String)"y", (double)0.0), GsonHelper.m_144742_((JsonObject)offsetsJson, (String)"z", (double)0.0));
        }

        public void clear() {
            BACKPACK_DEFAULT_TRANSLATIONS.clear();
            BACKPACK_ARMOR_TRANSLATIONS.clear();
        }
    }
}

