/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacksvh.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModelManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModelProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.BasicBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.DiamondBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.GoldBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.IronBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.ModBlockColors;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.ModItemColors;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.NetheriteBackpackModel;

public class ClientEventHandler {
    public static final ModelLayerLocation BASIC_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacksvh", "basic_backpack"), "main");
    public static final ModelLayerLocation IRON_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacksvh", "iron_backpack"), "main");
    public static final ModelLayerLocation GOLD_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacksvh", "gold_backpack"), "main");
    public static final ModelLayerLocation DIAMOND_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacksvh", "diamond_backpack"), "main");
    public static final ModelLayerLocation NETHERITE_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacksvh", "netherite_backpack"), "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::loadComplete);
        BackpackModelManager.registerBackpackModelProvider((IBackpackModelProvider)new IBackpackModelProvider(){
            private final Map<Item, IBackpackModel> backpackModels = new HashMap<Item, IBackpackModel>();
            private IBackpackModel defaultModel;

            public void initModels() {
                if (this.defaultModel == null) {
                    EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
                    this.defaultModel = new BackpackModel(entityModels.m_171103_(net.p3pp3rf1y.sophisticatedbackpacks.client.ClientEventHandler.BACKPACK_LAYER));
                    this.backpackModels.put((Item)ModItems.BACKPACK.get(), new BasicBackpackModel(entityModels.m_171103_(BASIC_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.IRON_BACKPACK.get(), new IronBackpackModel(entityModels.m_171103_(IRON_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.GOLD_BACKPACK.get(), new GoldBackpackModel(entityModels.m_171103_(GOLD_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.DIAMOND_BACKPACK.get(), new DiamondBackpackModel(entityModels.m_171103_(DIAMOND_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.NETHERITE_BACKPACK.get(), new NetheriteBackpackModel(entityModels.m_171103_(NETHERITE_BACKPACK_LAYER)));
                }
            }

            public void initModels(BlockEntityRendererProvider.Context context) {
                if (this.defaultModel == null) {
                    this.defaultModel = new BackpackModel(context.m_173582_(net.p3pp3rf1y.sophisticatedbackpacks.client.ClientEventHandler.BACKPACK_LAYER));
                    this.backpackModels.put((Item)ModItems.BACKPACK.get(), new BasicBackpackModel(context.m_173582_(BASIC_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.IRON_BACKPACK.get(), new IronBackpackModel(context.m_173582_(IRON_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.GOLD_BACKPACK.get(), new GoldBackpackModel(context.m_173582_(GOLD_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.DIAMOND_BACKPACK.get(), new DiamondBackpackModel(context.m_173582_(DIAMOND_BACKPACK_LAYER)));
                    this.backpackModels.put((Item)ModItems.NETHERITE_BACKPACK.get(), new NetheriteBackpackModel(context.m_173582_(NETHERITE_BACKPACK_LAYER)));
                }
            }

            public IBackpackModel getBackpackModel(Item backpackItem) {
                return this.backpackModels.getOrDefault(backpackItem, this.defaultModel);
            }
        });
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ModItemColors.init();
            ModBlockColors.init();
        });
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BASIC_BACKPACK_LAYER, BasicBackpackModel::createBodyLayer);
        event.registerLayerDefinition(IRON_BACKPACK_LAYER, IronBackpackModel::createBodyLayer);
        event.registerLayerDefinition(GOLD_BACKPACK_LAYER, GoldBackpackModel::createBodyLayer);
        event.registerLayerDefinition(DIAMOND_BACKPACK_LAYER, DiamondBackpackModel::createBodyLayer);
        event.registerLayerDefinition(NETHERITE_BACKPACK_LAYER, NetheriteBackpackModel::createBodyLayer);
    }
}

