/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacksvh.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.BackpackArmorOffsetsManager;
import net.p3pp3rf1y.sophisticatedbackpacksvh.client.DefaultBackpackColors;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;

public class GoldBackpackModel<T extends Entity>
extends EntityModel<T>
implements IBackpackModel {
    private static final ResourceLocation NO_TINT_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/block/gold_backpack_no_tint.png");
    private static final ResourceLocation MAIN_TINT_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/block/gold_backpack_main.png");
    private static final ResourceLocation ACCENT_TINT_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/block/gold_backpack_accent.png");
    private final ModelPart frontPouches;
    private final ModelPart backPouches;
    private final ModelPart belt;

    public GoldBackpackModel(ModelPart root) {
        this.frontPouches = root.m_171324_("frontPouches");
        this.backPouches = root.m_171324_("backPouches");
        this.belt = root.m_171324_("belt");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("frontPouches", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(1.5f, -4.0f, -4.1f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-4.5f, -4.0f, -4.1f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("backPouches", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-4.5f, -4.0f, 2.1f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(1.5f, -4.0f, 2.1f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("belt", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.frontPouches.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.belt.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public <L extends LivingEntity, M extends EntityModel<L>> void translateRotateAndScale(M parentModel, LivingEntity livingEntity, PoseStack poseStack, boolean wearsArmor) {
        if (parentModel instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)parentModel;
            humanoidModel.f_102810_.m_104299_(poseStack);
        } else {
            if (livingEntity.m_6047_()) {
                poseStack.m_85837_(0.0, 0.2, 0.0);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(28.647888f));
            }
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        float yOffset = -0.85f;
        boolean bl = this.belt.f_104207_ = !wearsArmor;
        if (livingEntity.m_6162_()) {
            poseStack.m_85841_(0.55f, 0.55f, 0.55f);
            yOffset = 0.45f;
        }
        poseStack.m_85837_(0.0, (double)yOffset, 0.0);
        poseStack.m_85841_(1.01f, 1.01f, 1.01f);
        double zOffset = wearsArmor ? BackpackArmorOffsetsManager.getOffsets((Item)ModItems.BACKPACK.get(), livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_()).map(offsets -> offsets.f_86216_).orElse(0.0) * 16.0 : 0.0;
        this.frontPouches.m_104227_(0.0f, 24.0f, (float)(-zOffset));
        this.backPouches.m_104227_(0.0f, 24.0f, (float)zOffset);
    }

    public <L extends LivingEntity, M extends EntityModel<L>> void render(M parentModel, LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int mainColor, int accentColor, Item backpackItem, RenderInfo renderInfo) {
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)NO_TINT_TEXTURE));
        if (mainColor == 13394234) {
            mainColor = DefaultBackpackColors.getDefaultMainColor(backpackItem);
        }
        if (accentColor == 6434330) {
            accentColor = DefaultBackpackColors.getDefaultAccentColor(backpackItem);
        }
        this.frontPouches.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
        this.backPouches.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
        this.belt.m_104301_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_);
        float accentRed = (float)(accentColor >> 16 & 0xFF) / 255.0f;
        float accentGreen = (float)(accentColor >> 8 & 0xFF) / 255.0f;
        float accentBlue = (float)(accentColor & 0xFF) / 255.0f;
        float mainRed = (float)(mainColor >> 16 & 0xFF) / 255.0f;
        float mainGreen = (float)(mainColor >> 8 & 0xFF) / 255.0f;
        float mainBlue = (float)(mainColor & 0xFF) / 255.0f;
        vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)MAIN_TINT_TEXTURE));
        this.frontPouches.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, mainRed, mainGreen, mainBlue, 1.0f);
        this.backPouches.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, mainRed, mainGreen, mainBlue, 1.0f);
        vertexBuilder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)ACCENT_TINT_TEXTURE));
        this.frontPouches.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, accentRed, accentGreen, accentBlue, 1.0f);
        this.backPouches.m_104306_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, accentRed, accentGreen, accentBlue, 1.0f);
    }

    public void renderBatteryCharge(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float chargeRatio) {
    }

    public void renderFluid(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, Fluid fluid, float fill, boolean left) {
    }

    public EquipmentSlot getRenderEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }
}

