/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.external;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.api.config.IConfigCategory;
import vazkii.quark.api.config.IExternalCategory;
import vazkii.quark.api.config.IQuarkConfig;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.external.ExternalCategory;

public final class ExternalConfigHandler
implements IQuarkConfig {
    public static ExternalConfigHandler instance;
    public Multimap<String, IExternalCategory> externalCategories = HashMultimap.create();
    public ConfigCategory mockCategory = null;
    private int lastConfigChange = 0;

    public void setAPIHandler() {
        instance = this;
        IQuarkConfig.Holder.instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void configChanged(ModConfigEvent event) {
        String modid = event.getConfig().getModId();
        if (this.externalCategories.containsKey((Object)modid) && ClientTicker.ticksInGame - this.lastConfigChange > 10) {
            this.lastConfigChange = ClientTicker.ticksInGame;
            for (IExternalCategory category : this.externalCategories.get((Object)modid)) {
                category.refresh();
            }
        }
    }

    public boolean hasAny() {
        return !this.externalCategories.isEmpty();
    }

    public void commit() {
        this.externalCategories.values().stream().forEach(IExternalCategory::commit);
    }

    @Override
    public IExternalCategory registerExternalCategory(String modid, String name, Consumer<IExternalCategory> onChangedCallback) {
        if (this.mockCategory == null) {
            this.mockCategory = new ConfigCategory("friends", "", null, null);
        }
        ExternalCategory category = new ExternalCategory(name, onChangedCallback, (IConfigCategory)this.mockCategory);
        this.externalCategories.put((Object)modid, (Object)category);
        this.mockCategory.addCategory(category);
        return category;
    }

    @Override
    public Consumer<IExternalCategory> writeToFileCallback(File file) {
        return c -> {
            if (c.isDirty()) {
                try {
                    file.createNewFile();
                    PrintStream stream = new PrintStream(file);
                    c.print("", stream);
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                c.clean();
            }
        };
    }
}

