/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type.inputtable;

import java.util.Objects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.inputtable.RGBColorConfig;

public class RGBAColorConfig
extends RGBColorConfig {
    @Config
    public double a;
    protected double da;

    private RGBAColorConfig(double r, double g, double b, double a) {
        super(r, g, b, a);
        this.a = a;
    }

    public static RGBAColorConfig forColor(double r, double g, double b, double a) {
        RGBAColorConfig config = new RGBAColorConfig(r, g, b, a);
        config.color = config.calculateColor();
        config.dr = r;
        config.dg = g;
        config.db = b;
        config.da = a;
        return config;
    }

    @Override
    public double getAlphaComponent() {
        return this.a;
    }

    @Override
    void setAlphaComponent(double c) {
        this.a = c;
    }

    @Override
    public void inherit(RGBColorConfig other, boolean committing) {
        if (other instanceof RGBAColorConfig) {
            RGBAColorConfig rgba = (RGBAColorConfig)other;
            this.a = rgba.a;
            if (!committing) {
                this.da = rgba.a;
            }
        }
        super.inherit(other, committing);
    }

    @Override
    public void inheritDefaults(RGBColorConfig target) {
        double d;
        if (target instanceof RGBAColorConfig) {
            RGBAColorConfig rgba = (RGBAColorConfig)target;
            d = rgba.da;
        } else {
            d = 1.0;
        }
        this.a = d;
        super.inheritDefaults(target);
    }

    @Override
    public RGBAColorConfig copy() {
        RGBAColorConfig newMatrix = new RGBAColorConfig(this.r, this.g, this.b, this.a);
        newMatrix.inherit(this, false);
        return newMatrix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RGBAColorConfig that = (RGBAColorConfig)o;
        return Double.compare(that.r, this.r) == 0 && Double.compare(that.g, this.g) == 0 && Double.compare(that.b, this.b) == 0 && Double.compare(that.a, this.a) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.r, this.g, this.b, this.a);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getSubtitle() {
        return String.format("[%.1f, %.1f, %.1f, %.1f]", this.r, this.g, this.b, this.a);
    }
}

