/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.tools.item.AncientTomeItem;
import vazkii.quark.content.tools.module.AncientTomesModule;

public class EnchantedBookTooltips {
    private static List<ItemStack> testItems = null;
    private static Multimap<Enchantment, ItemStack> additionalStacks = null;

    public static void reloaded() {
        additionalStacks = null;
        testItems = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(RenderTooltipEvent.GatherComponents event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == Items.f_42690_ || stack.m_41720_() == AncientTomesModule.ancient_tome) {
            List tooltip = event.getTooltipElements();
            int tooltipIndex = 0;
            List<EnchantmentInstance> enchants = EnchantedBookTooltips.getEnchantedBookEnchantments(stack);
            block0: for (EnchantmentInstance ed : enchants) {
                Component match = stack.m_41720_() == Items.f_42690_ ? ed.f_44947_.m_44700_(ed.f_44948_) : AncientTomeItem.getFullTooltipText(ed.f_44947_);
                while (tooltipIndex < tooltip.size()) {
                    Either elmAt = (Either)tooltip.get(tooltipIndex);
                    if (elmAt.left().isPresent() && ((FormattedText)elmAt.left().get()).equals(match)) {
                        List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(ed.f_44947_);
                        int itemCount = items.size();
                        int lines = (int)Math.ceil((double)itemCount / 10.0);
                        int len = 3 + Math.min(10, itemCount) * 9;
                        tooltip.add(tooltipIndex + 1, Either.right((Object)new EnchantedBookComponent(len, lines * 10, ed.f_44947_)));
                        continue block0;
                    }
                    ++tooltipIndex;
                }
            }
        }
    }

    public static List<ItemStack> getItemsForEnchantment(Enchantment e) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : EnchantedBookTooltips.getTestItems()) {
            Item item = stack.m_41720_();
            if (item instanceof QuarkItem && !((QuarkItem)item).isEnabled() || stack.m_41619_() || !e.m_6081_(stack)) continue;
            list.add(stack);
        }
        if (EnchantedBookTooltips.getAdditionalStacks().containsKey((Object)e)) {
            list.addAll(EnchantedBookTooltips.getAdditionalStacks().get((Object)e));
        }
        return list;
    }

    public static List<EnchantmentInstance> getEnchantedBookEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        ArrayList<EnchantmentInstance> retList = new ArrayList<EnchantmentInstance>(enchantments.size());
        for (Enchantment enchantment : enchantments.keySet()) {
            if (enchantment == null) continue;
            int level = (Integer)enchantments.get(enchantment);
            retList.add(new EnchantmentInstance(enchantment, level));
        }
        return retList;
    }

    private static Multimap<Enchantment, ItemStack> getAdditionalStacks() {
        if (additionalStacks == null) {
            EnchantedBookTooltips.computeAdditionalStacks();
        }
        return additionalStacks;
    }

    public static List<ItemStack> getTestItems() {
        if (testItems == null) {
            EnchantedBookTooltips.computeTestItems();
        }
        return testItems;
    }

    private static void computeTestItems() {
        testItems = Lists.newArrayList();
        for (String loc : ImprovedTooltipsModule.enchantingStacks) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(loc));
            if (item == null) continue;
            testItems.add(new ItemStack((ItemLike)item));
        }
    }

    private static void computeAdditionalStacks() {
        additionalStacks = HashMultimap.create();
        for (String s : ImprovedTooltipsModule.enchantingAdditionalStacks) {
            if (!s.contains("=")) continue;
            String[] tokens = s.split("=");
            String left = tokens[0];
            String right = tokens[1];
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(left));
            if (ench == null) continue;
            for (String itemId : tokens = right.split(",")) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                if (item == null) continue;
                additionalStacks.put((Object)ench, (Object)new ItemStack((ItemLike)item));
            }
        }
    }

    public record EnchantedBookComponent(int width, int height, Enchantment enchantment) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@Nonnull Font font, int tooltipX, int tooltipY, @Nonnull PoseStack basePose, @Nonnull ItemRenderer itemRenderer, int something) {
            PoseStack modelviewPose = RenderSystem.m_157191_();
            modelviewPose.m_85836_();
            modelviewPose.m_85837_((double)tooltipX, (double)tooltipY, 0.0);
            modelviewPose.m_85841_(0.5f, 0.5f, 1.0f);
            Minecraft mc = Minecraft.m_91087_();
            List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(this.enchantment);
            int drawn = 0;
            for (ItemStack testStack : items) {
                mc.m_91291_().m_115123_(testStack, 6 + drawn % 10 * 18, drawn / 10 * 20);
                ++drawn;
            }
            modelviewPose.m_85849_();
            RenderSystem.m_157182_();
        }

        public int m_142103_() {
            return this.height;
        }

        public int m_142069_(@Nonnull Font font) {
            return this.width;
        }
    }
}

