/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.OptionalInt;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.module.BlossomTreesModule;

public class BlossomSaplingBlock
extends SaplingBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public BlossomSaplingBlock(String colorName, QuarkModule module, BlossomTree tree, Block leaf) {
        super((AbstractTreeGrower)tree, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_));
        this.module = module;
        RegistryHelper.registerBlock((Block)this, (String)(colorName + "_blossom_sapling"));
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40750_);
        tree.sapling = this;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public BlossomSaplingBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    public static class BlossomTree
    extends AbstractTreeGrower {
        public final TreeConfiguration config;
        public final BlockState leaf;
        public BlossomSaplingBlock sapling;

        public BlossomTree(Block leafBlock) {
            this.config = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)BlossomTreesModule.woodSet.log), (TrunkPlacer)new FancyTrunkPlacer(8, 10, 10), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leafBlock), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)1), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_().m_68251_();
            this.leaf = leafBlock.m_49966_();
        }

        protected Holder<ConfiguredFeature<TreeConfiguration, ?>> m_203525_(@Nonnull Random rand, boolean hjskfsd) {
            return Holder.m_205709_((Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)this.config));
        }
    }
}

