/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.block.QuarkBushBlock;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.QuarkModule;

public class GlowLichenGrowthBlock
extends QuarkBushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public GlowLichenGrowthBlock(QuarkModule module) {
        super("glow_lichen_growth", module, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152475_).m_60977_().m_60953_(s -> 8));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(@Nonnull BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        super.m_7100_(stateIn, worldIn, pos, rand);
        for (int i = 0; i < 10; ++i) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + (Math.random() - 0.5) * 5.0 + 0.5, (double)pos.m_123342_() + (Math.random() - 0.5) * 8.0 + 0.5, (double)pos.m_123343_() + (Math.random() - 0.5) * 5.0 + 0.5, 0.0, 0.0, 0.0);
        }
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + (Math.random() - 0.5) * 0.4 + 0.5, (double)pos.m_123342_() + (Math.random() - 0.5) * 0.3 + 0.3, (double)pos.m_123343_() + (Math.random() - 0.5) * 0.4 + 0.5, 0.0, 0.0, 0.0);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    protected boolean m_6266_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return state.m_60783_(world, pos, Direction.UP);
    }

    public boolean m_7370_(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean idkmansomething) {
        for (Direction dir : MiscUtil.HORIZONTALS) {
            if (!this.canSpread(world, pos.m_142300_(dir))) continue;
            return true;
        }
        return false;
    }

    public boolean m_5491_(@Nonnull Level world, @Nonnull Random random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public void m_7719_(@Nonnull ServerLevel world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        ArrayList list = Lists.newArrayList((Object[])MiscUtil.HORIZONTALS);
        Collections.shuffle(list, rand);
        for (Direction dir : list) {
            BlockPos offPos = pos.m_142300_(dir);
            if (!this.canSpread((BlockGetter)world, offPos)) continue;
            world.m_7731_(offPos, state, 3);
            return;
        }
    }

    private boolean canSpread(BlockGetter world, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return world.m_8055_(pos).m_60795_() && this.m_6266_(world.m_8055_(below), world, below);
    }
}

