/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.sluice;

import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftbstuffnthings.Config;
import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.FTBStuffTags;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.SerializableComponentsProvider;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceProperties;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceType;
import dev.ftb.mods.ftbstuffnthings.items.MeshItem;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.util.TextUtil;
import dev.ftb.mods.ftbstuffnthings.util.VoxelShapeUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SluiceBlock
extends AbstractMachineBlock
implements EntityBlock,
SerializableComponentsProvider {
    public static final EnumProperty<MeshType> MESH = EnumProperty.create((String)"mesh", MeshType.class);
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    private static final VoxelShape NORTH_BODY_SHAPE = VoxelShapeUtils.or(SluiceBlock.box((double)12.5, (double)0.0, (double)0.0, (double)14.5, (double)1.0, (double)1.0), SluiceBlock.box((double)1.5, (double)0.0, (double)13.5, (double)3.5, (double)1.0, (double)15.5), SluiceBlock.box((double)12.5, (double)0.0, (double)13.5, (double)14.5, (double)1.0, (double)15.5), SluiceBlock.box((double)1.5, (double)0.0, (double)0.0, (double)3.5, (double)1.0, (double)1.0), SluiceBlock.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0), SluiceBlock.box((double)14.0, (double)2.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0), SluiceBlock.box((double)1.0, (double)2.0, (double)0.0, (double)2.0, (double)8.0, (double)16.0), SluiceBlock.box((double)2.0, (double)5.0, (double)0.0, (double)14.0, (double)8.0, (double)1.0), SluiceBlock.box((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)8.0, (double)16.0), SluiceBlock.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)2.5, (double)1.0), SluiceBlock.box((double)2.0, (double)7.0, (double)1.0, (double)14.0, (double)12.0, (double)2.0), SluiceBlock.box((double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)12.0, (double)15.0), SluiceBlock.box((double)13.0, (double)7.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), SluiceBlock.box((double)2.0, (double)7.0, (double)2.0, (double)3.0, (double)12.0, (double)14.0));
    private static final VoxelShape EAST_BODY_SHAPE = VoxelShapeUtils.rotateY(NORTH_BODY_SHAPE, 90);
    private static final VoxelShape SOUTH_BODY_SHAPE = VoxelShapeUtils.rotateY(NORTH_BODY_SHAPE, 180);
    private static final VoxelShape WEST_BODY_SHAPE = VoxelShapeUtils.rotateY(NORTH_BODY_SHAPE, 270);
    private static final VoxelShape NORTH_FRONT_SHAPE = VoxelShapeUtils.or(SluiceBlock.box((double)2.0, (double)1.5, (double)12.0, (double)14.0, (double)2.5, (double)13.0), SluiceBlock.box((double)1.0, (double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)16.0), SluiceBlock.box((double)2.0, (double)1.5, (double)8.0, (double)14.0, (double)2.5, (double)9.0), SluiceBlock.box((double)2.0, (double)1.5, (double)4.0, (double)14.0, (double)2.5, (double)5.0), SluiceBlock.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0), SluiceBlock.box((double)14.0, (double)2.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0), SluiceBlock.box((double)12.5, (double)0.0, (double)0.5, (double)14.5, (double)1.0, (double)2.5), SluiceBlock.box((double)1.5, (double)0.0, (double)0.5, (double)3.5, (double)1.0, (double)2.5), SluiceBlock.box((double)1.5, (double)0.0, (double)15.0, (double)3.5, (double)1.0, (double)16.0), SluiceBlock.box((double)12.5, (double)0.0, (double)15.0, (double)14.5, (double)1.0, (double)16.0));
    private static final VoxelShape EAST_FRONT_SHAPE = VoxelShapeUtils.rotateY(NORTH_FRONT_SHAPE, 90);
    private static final VoxelShape SOUTH_FRONT_SHAPE = VoxelShapeUtils.rotateY(NORTH_FRONT_SHAPE, 180);
    private static final VoxelShape WEST_FRONT_SHAPE = VoxelShapeUtils.rotateY(NORTH_FRONT_SHAPE, 270);
    private static final Map<Direction, Pair<VoxelShape, VoxelShape>> SHAPES = new EnumMap<Direction, Pair>(Map.of(Direction.NORTH, Pair.of((Object)NORTH_BODY_SHAPE, (Object)NORTH_FRONT_SHAPE), Direction.EAST, Pair.of((Object)EAST_BODY_SHAPE, (Object)EAST_FRONT_SHAPE), Direction.SOUTH, Pair.of((Object)SOUTH_BODY_SHAPE, (Object)SOUTH_FRONT_SHAPE), Direction.WEST, Pair.of((Object)WEST_BODY_SHAPE, (Object)WEST_FRONT_SHAPE)));
    private final SluiceType sluiceType;
    private final Lazy<SluiceProperties> props;

    public SluiceBlock(SluiceType sluiceType, SoundType soundType) {
        super(BlockBehaviour.Properties.of().sound(soundType).strength(0.9f).forceSolidOn());
        this.sluiceType = sluiceType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(MESH, (Comparable)((Object)MeshType.EMPTY))).setValue(PART, (Comparable)((Object)Part.MAIN))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.props = Config.makeSluiceProperties(sluiceType);
    }

    @Override
    protected boolean hasActiveStateProperty() {
        return false;
    }

    public SluiceProperties getProps() {
        return (SluiceProperties)this.props.get();
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return state.getValue(PART) == Part.FUNNEL ? List.of() : super.getDrops(state, params);
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (!SHAPES.containsKey(direction)) {
            return Shapes.empty();
        }
        Pair<VoxelShape, VoxelShape> bodyFrontShapes = SHAPES.get(direction);
        return state.getValue(PART) == Part.MAIN ? (VoxelShape)bodyFrontShapes.getFirst() : (VoxelShape)bodyFrontShapes.getSecond();
    }

    @Deprecated
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() && state.getValue(MESH) != MeshType.EMPTY) {
            ItemStack current = ((MeshType)((Object)state.getValue(MESH))).getItemStack();
            level.setBlock(pos, (BlockState)state.setValue(MESH, (Comparable)((Object)MeshType.EMPTY)), 3);
            if (!level.isClientSide()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)current);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (state.getValue(PART) == Part.FUNNEL) return ItemInteractionResult.FAIL;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SluiceBlockEntity)) return ItemInteractionResult.FAIL;
        SluiceBlockEntity sluice = (SluiceBlockEntity)blockEntity;
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(FTBStuffTags.Items.MESHES)) {
            Item item = stack.getItem();
            if (!(item instanceof MeshItem)) {
                FTBStuffNThings.LOGGER.error("item {} wrongly added added to item tag {} (not a MeshItem)!", (Object)stack.getHoverName().getString(), FTBStuffTags.Items.MESHES);
                return ItemInteractionResult.FAIL;
            }
            MeshItem meshItem = (MeshItem)item;
            if (this.isMeshCompatibleWith(meshItem.mesh)) {
                ItemStack current = ((MeshType)((Object)state.getValue(MESH))).getItemStack();
                level.setBlock(pos, (BlockState)state.setValue(MESH, (Comparable)((Object)meshItem.mesh)), 3);
                if (player.isCreative()) return ItemInteractionResult.CONSUME;
                stack.shrink(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)current);
                return ItemInteractionResult.CONSUME;
            }
            player.displayClientMessage((Component)Component.translatable((String)"ftbstuff.wrong_mesh").withStyle(ChatFormatting.GOLD), true);
            return ItemInteractionResult.FAIL;
        }
        if (!(stack.getItem() instanceof BucketItem) && stack.getCapability(Capabilities.FluidHandler.ITEM) == null) {
            sluice.getRecipeFor(stack).ifPresent(recipe -> {
                IItemHandler handler = Objects.requireNonNull(sluice.getItemHandler());
                ItemStack excess = handler.insertItem(0, stack.copyWithCount(1), false);
                if (excess.isEmpty()) {
                    sluice.setChanged();
                    sluice.syncItemToClients();
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
            });
            return ItemInteractionResult.CONSUME;
        }
        FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)Objects.requireNonNull(sluice.getFluidHandler()));
        return ItemInteractionResult.CONSUME;
    }

    private boolean isMeshCompatibleWith(MeshType type) {
        return this.builtInRegistryHolder().is(FTBStuffTags.Blocks.allowedMeshes(type));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MESH, PART, BlockStateProperties.HORIZONTAL_FACING});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos offsetPos = context.getClickedPos().relative(context.getHorizontalDirection().getOpposite());
        return context.getLevel().getBlockState(offsetPos).canBeReplaced(context) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(PART, (Comparable)((Object)Part.MAIN)) : null;
    }

    @Deprecated
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return super.updateShape(state, facing, facingState, world, pos, facingPos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockPos endPos;
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (state.getValue(PART) == Part.FUNNEL && level.getBlockState(endPos = pos.relative(direction.getOpposite())).getBlock() instanceof SluiceBlock) {
            level.destroyBlock(endPos, !level.isClientSide);
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    @Deprecated
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockPos otherPos = pos.relative(state.getValue(PART) == Part.FUNNEL ? direction.getOpposite() : direction);
            if (state.getValue(PART) != Part.FUNNEL) {
                world.removeBlock(otherPos, false);
                SluiceBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)((MeshType)((Object)state.getValue(MESH))).getItemStack());
                super.onRemove(state, world, pos, newState, isMoving);
            }
        } else {
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        boolean isShift = Screen.hasShiftDown();
        if (isShift) {
            tooltip.add((Component)Component.translatable((String)"ftbstuff.sluice.props.processing_time", (Object[])new Object[]{Component.literal((String)String.valueOf(((SluiceProperties)this.props.get()).timeMod().get())).withStyle(TextUtil.COLOUR_HIGHLIGHT)}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"ftbstuff.sluice.props.fluid_usage", (Object[])new Object[]{Component.literal((String)String.valueOf(((SluiceProperties)this.props.get()).fluidMod().get())).withStyle(TextUtil.COLOUR_HIGHLIGHT)}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"ftbstuff.sluice.props.tank", (Object[])new Object[]{Component.literal((String)String.valueOf(((SluiceProperties)this.props.get()).tankCap().get())).withStyle(TextUtil.COLOUR_HIGHLIGHT)}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"ftbstuff.sluice.props.auto", (Object[])new Object[]{Component.translatable((String)"ftbstuff.sluice.props.auto.item").withStyle(TextUtil.ofBoolean((Boolean)((SluiceProperties)this.props.get()).itemIO().get())), Component.translatable((String)"ftbstuff.sluice.props.auto.fluid").withStyle(TextUtil.ofBoolean((Boolean)((SluiceProperties)this.props.get()).fluidIO().get()))}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"ftbstuff.hold_shift").withStyle(ChatFormatting.GRAY));
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack item) {
        super.setPlacedBy(level, pos, state, entity, item);
        if (!level.isClientSide) {
            BlockPos lv = pos.relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
            level.setBlock(lv, (BlockState)state.setValue(PART, (Comparable)((Object)Part.FUNNEL)), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (!blockState.hasProperty(PART) || blockState.getValue(PART) == Part.FUNNEL) {
            return null;
        }
        return this.sluiceType.createBlockEntity(blockPos, blockState);
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        if ((Integer)this.getProps().energyCost().get() > 0) {
            list.add(ComponentsRegistry.STORED_ENERGY.get());
        }
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return state;
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state;
    }

    public static enum Part implements StringRepresentable
    {
        MAIN("main"),
        FUNNEL("funnel");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

