/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbstuffnthings.client.GuiUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public abstract class BaseFluidAndEnergyScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private final int fluidXOffset;
    private final int progressXOffset;
    private final ResourceLocation texture;

    public BaseFluidAndEnergyScreen(T menu, Inventory inventory, Component title, int fluidXOffset, int progressXOffset, ResourceLocation texture) {
        super(menu, inventory, title);
        this.fluidXOffset = fluidXOffset;
        this.progressXOffset = progressXOffset;
        this.texture = texture;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (mouseX > this.leftPos + this.fluidXOffset && mouseX < this.leftPos + this.fluidXOffset + 19 && mouseY > this.topPos + 3 && mouseY < this.topPos + 5 + 65) {
            List<MutableComponent> tooltip = this.getFluidStack().isEmpty() ? List.of(Component.translatable((String)"ftblibrary.empty")) : List.of(this.getFluidStack().getHoverName(), Component.literal((String)(this.getFluidStack().getAmount() + " / " + this.getFluidCapacity() + " mB")));
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (mouseX > this.leftPos + 166 && mouseX < this.leftPos + 174 && mouseY > this.topPos + 3 && mouseY < this.topPos + 5 + 65) {
            MutableComponent energyText = Component.literal((String)(this.getEnergyAmount() + " / " + this.getEnergyCapacity() + " FE"));
            graphics.renderTooltip(this.font, (Component)energyText, mouseX, mouseY);
        }
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        PoseStack poseStack = graphics.pose();
        graphics.blit(this.texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        if (this.getEnergyCapacity() > 0) {
            float x = (float)this.getEnergyAmount() / (float)this.getEnergyCapacity();
            int energyHeight = (int)(x * 65.0f);
            graphics.blit(this.texture, this.leftPos + this.imageWidth - 9, this.topPos + 4 + 65 - energyHeight, 197, 69 - energyHeight, 5, energyHeight);
            poseStack.popPose();
        }
        RenderSystem.disableBlend();
        if (this.getFluidCapacity() > 0) {
            Rect2i bounds = new Rect2i(this.leftPos + this.fluidXOffset + 1, this.topPos + 4, 16, 65);
            GuiUtil.drawFluid(graphics, bounds, this.getFluidStack(), (IFluidTank)new FluidTank(this.getFluidCapacity()));
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 101.0f);
            graphics.blit(this.texture, this.leftPos + (this.fluidXOffset + 1), this.topPos + 6, 178, 3, 18, 67);
            poseStack.popPose();
        }
        if (this.getProgressRequired() > 0) {
            float computedPercentage = (float)this.getProgress() / (float)this.getProgressRequired() * 24.0f;
            graphics.blit(this.texture, this.leftPos + this.progressXOffset, this.topPos + 28, 203, 0, (int)computedPercentage + 1, 16);
        }
    }

    public abstract int getEnergyAmount();

    public abstract int getEnergyCapacity();

    public abstract int getFluidCapacity();

    public abstract FluidStack getFluidStack();

    public abstract int getProgress();

    public abstract int getProgressRequired();
}

