/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.BaseRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;

public class WoodenBasinRecipe
extends BaseRecipe<WoodenBasinRecipe> {
    private final String inputStateStr;
    private final FluidStack outputFluid;
    private final float productionChance;
    private final float blockConsumeChance;
    private final boolean dropItems;
    private final Lazy<BlockPredicateArgument.Result> inputPredicate;

    public WoodenBasinRecipe(String inputStateStr, FluidStack outputFluid, float productionChance, float blockConsumeChance, boolean dropItems) {
        super(RecipesRegistry.WOODEN_BASIN_SERIALIZER, RecipesRegistry.WOODEN_BASIN_TYPE);
        this.inputStateStr = inputStateStr;
        this.outputFluid = outputFluid;
        this.productionChance = productionChance;
        this.blockConsumeChance = blockConsumeChance;
        this.dropItems = dropItems;
        this.inputPredicate = Lazy.of(() -> {
            try {
                return BlockPredicateArgument.parse((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(inputStateStr));
            }
            catch (CommandSyntaxException e) {
                return new BadResult();
            }
        });
    }

    private Set<Block> getInputBlocks() {
        Object object = this.inputPredicate.get();
        if (object instanceof BlockPredicateArgument.BlockPredicate) {
            BlockPredicateArgument.BlockPredicate b = (BlockPredicateArgument.BlockPredicate)object;
            return Set.of(b.state.getBlock());
        }
        object = this.inputPredicate.get();
        if (object instanceof BlockPredicateArgument.TagPredicate) {
            BlockPredicateArgument.TagPredicate t = (BlockPredicateArgument.TagPredicate)object;
            return t.tag.stream().map(Holder::value).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public List<Either<ItemStack, Fluid>> getInputsForDisplay() {
        Set<Block> blocks = this.getInputBlocks();
        ArrayList<Either<ItemStack, Fluid>> res = new ArrayList<Either<ItemStack, Fluid>>();
        for (Block b : blocks) {
            if (b instanceof LiquidBlock) {
                LiquidBlock l = (LiquidBlock)b;
                if (l.fluid == Fluids.EMPTY) continue;
                res.add((Either<ItemStack, Fluid>)Either.right((Object)l.fluid));
                continue;
            }
            ItemStack s = b.asItem().getDefaultInstance();
            if (s.isEmpty()) continue;
            res.add((Either<ItemStack, Fluid>)Either.left((Object)s));
        }
        return res;
    }

    public String getInputStateStr() {
        return this.inputStateStr;
    }

    public float getProductionChance() {
        return this.productionChance;
    }

    public float getBlockConsumeChance() {
        return this.blockConsumeChance;
    }

    public FluidStack getFluid() {
        return this.outputFluid;
    }

    public boolean testInput(BlockInWorld state) {
        return ((BlockPredicateArgument.Result)this.inputPredicate.get()).test((Object)state);
    }

    public boolean dropItems() {
        return this.dropItems;
    }

    private static class BadResult
    implements BlockPredicateArgument.Result {
        private BadResult() {
        }

        public boolean test(BlockInWorld blockInWorld) {
            return false;
        }

        public boolean requiresNbt() {
            return false;
        }
    }

    public static class Serializer<T extends WoodenBasinRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("input").forGetter(WoodenBasinRecipe::getInputStateStr), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(WoodenBasinRecipe::getFluid), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(WoodenBasinRecipe::getProductionChance), (App)Codec.FLOAT.optionalFieldOf("block_consume_chance", (Object)Float.valueOf(1.0f)).forGetter(WoodenBasinRecipe::getBlockConsumeChance), (App)Codec.BOOL.optionalFieldOf("drop_items", (Object)false).forGetter(WoodenBasinRecipe::dropItems)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, WoodenBasinRecipe::getInputStateStr, (StreamCodec)FluidStack.STREAM_CODEC, WoodenBasinRecipe::getFluid, (StreamCodec)ByteBufCodecs.FLOAT, WoodenBasinRecipe::getProductionChance, (StreamCodec)ByteBufCodecs.FLOAT, WoodenBasinRecipe::getBlockConsumeChance, (StreamCodec)ByteBufCodecs.BOOL, WoodenBasinRecipe::dropItems, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends WoodenBasinRecipe> {
        public T create(String var1, FluidStack var2, float var3, float var4, boolean var5);
    }
}

