/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data.recipe;

import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.SluiceRecipe;
import dev.ftb.mods.ftbstuffnthings.data.recipe.BaseRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class SluiceRecipeBuilder
extends BaseRecipeBuilder<SluiceRecipe> {
    private final Ingredient ingredient;
    private final List<ItemWithChance> results;
    private int maxResults;
    @Nullable
    private SizedFluidIngredient fluid;
    private float processingTimeMultiplier;
    private final HashSet<MeshType> meshTypes;

    public SluiceRecipeBuilder(Ingredient ingredient, List<ItemWithChance> results, List<MeshType> meshTypes) {
        this.ingredient = ingredient;
        this.results = results;
        this.maxResults = 4;
        this.fluid = SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)10);
        this.processingTimeMultiplier = 1.0f;
        this.meshTypes = new HashSet<MeshType>(meshTypes);
    }

    public SluiceRecipeBuilder maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public SluiceRecipeBuilder fluid(FluidStack fluid) {
        this.fluid = SizedFluidIngredient.of((FluidStack)fluid);
        return this;
    }

    public SluiceRecipeBuilder noFluid() {
        this.fluid = null;
        return this;
    }

    public SluiceRecipeBuilder processingTimeMultiplier(float processingTimeMultiplier) {
        this.processingTimeMultiplier = processingTimeMultiplier;
        return this;
    }

    @Override
    protected SluiceRecipe buildRecipe() {
        return new SluiceRecipe(this.ingredient, this.results, this.maxResults, Optional.ofNullable(this.fluid), this.processingTimeMultiplier, List.copyOf(this.meshTypes));
    }
}

