/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.mixin;

import com.mojang.serialization.DynamicOps;
import dev.ftb.mods.ftbstuffnthings.FTBStuffTags;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Painting.class})
public abstract class PaintingMixin
extends HangingEntity {
    protected PaintingMixin(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"dropItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/Painting;spawnAtLocation(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/entity/item/ItemEntity;")}, cancellable=true)
    public void dropItem(Entity brokenEntity, CallbackInfo ci) {
        Painting painting = (Painting)this;
        Holder variant = painting.getVariant();
        if (variant.is(FTBStuffTags.Painting.DROPS_WITH_VARIANT)) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType()).toString());
            Painting.VARIANT_CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)variant).ifSuccess(tag -> compoundTag.merge((CompoundTag)tag));
            ItemStack itemStack = new ItemStack((ItemLike)Items.PAINTING);
            itemStack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
            this.spawnAtLocation(itemStack);
            ci.cancel();
        }
    }
}

