/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.network.payloads;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import com.schematicenergistics.SchematicEnergistics;
import com.schematicenergistics.logic.ICannonInterfaceHost;
import com.schematicenergistics.part.CannonInterfacePart;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenCannonInterfacePacket(BlockPos cannonBlockPos, BlockPos terminalBlockPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenCannonInterfacePacket> TYPE = new CustomPacketPayload.Type(SchematicEnergistics.makeId("open_cannon_interface"));
    public static final StreamCodec<ByteBuf, OpenCannonInterfacePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OpenCannonInterfacePacket::cannonBlockPos, (StreamCodec)BlockPos.STREAM_CODEC, OpenCannonInterfacePacket::terminalBlockPos, OpenCannonInterfacePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OpenCannonInterfacePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                BlockEntity blockEntity = player.level().getBlockEntity(packet.cannonBlockPos());
                if (blockEntity instanceof ICannonInterfaceHost) {
                    ICannonInterfaceHost host = (ICannonInterfaceHost)blockEntity;
                    host.getLogic().setTerminalPos(packet.terminalBlockPos());
                    MenuHostLocator locator = MenuLocators.forBlockEntity((BlockEntity)blockEntity);
                    host.openMenu((Player)player, locator);
                    return;
                }
                if (blockEntity instanceof IPartHost) {
                    IPartHost host = (IPartHost)blockEntity;
                    for (Direction direction : Direction.values()) {
                        IPart part = host.getPart(direction);
                        if (!(part instanceof CannonInterfacePart)) continue;
                        CannonInterfacePart cannonPart = (CannonInterfacePart)part;
                        cannonPart.getLogic().setTerminalPos(packet.terminalBlockPos());
                        MenuHostLocator locator = MenuLocators.forPart((AEBasePart)cannonPart);
                        cannonPart.openMenu((Player)player, locator);
                        return;
                    }
                }
            }
        });
    }
}

