/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import dev.xylonity.tooltipoverhaul.client.util.Palette;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.config.parser.ConfigColorParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;

public record CustomFrameData(List<String> items, List<String> tags, Optional<String> namespace, Optional<String> texture, Optional<Integer> backgroundColor, Optional<String> borderType, Optional<GradientType> gradientType, Optional<List<String>> gradientColors, Optional<String> itemRating, Optional<String> colorItemRating, Optional<String> ratingAlignment, Optional<String> titleAlignment, Optional<Integer> tooltipPositionX, Optional<Integer> tooltipPositionY, Optional<Integer> mainPanelPaddingX, Optional<Integer> mainPanelPaddingY, Optional<Integer> dividerLineTopPadding, Optional<Integer> dividerLineBottomPadding, Optional<Float> iconSize, Optional<Float> iconRotatingSpeed, Optional<String> iconAppearAnimation, Optional<Integer> secondPanelX, Optional<Integer> secondPanelY, Optional<Integer> secondPanelSizeX, Optional<Integer> secondPanelSizeY, Optional<Float> secondPanelRendererSpeed, Optional<String> dividerLineType, Optional<String> dividerLineColor, Optional<String> particles, Optional<String> specialEffect, List<String> vignettes, Optional<String> iconBackgroundType, Optional<Boolean> usePlayerSkinInPreview, Optional<String> previewPanelModel, Optional<Boolean> showSecondPanel, Optional<Boolean> showRating, Optional<Boolean> showShadow, Optional<Boolean> disableIcon, Optional<Boolean> disableScrolling, Optional<Boolean> disableTooltip, Optional<Boolean> disableDividerLine) {
    public String getTextureLocation() {
        return this.texture.filter(t -> !t.trim().isEmpty()).orElse(TooltipsConfig.GLOBAL_FRAME_OVERLAY_LOCATION);
    }

    public String getBorderType() {
        return this.borderType.orElse(TooltipsConfig.DEFAULT_INNER_OVERLAY_TYPE);
    }

    public GradientType getGradientType() {
        return this.gradientType.orElse(GradientType.COMMON);
    }

    public boolean hasGradientColors() {
        return this.gradientColors.isPresent();
    }

    public int[] getGradientColors(TooltipContext context) {
        return this.gradientColors.map(list -> {
            int i;
            int length = Math.min(3, list.size());
            if (length == 0) {
                return new int[0];
            }
            int[] array = new int[3];
            int last = 0;
            for (i = 0; i < length; ++i) {
                String key = (String)list.get(i);
                if (key == null || key.isBlank()) continue;
                array[i] = last = ConfigColorParser.parseColor(key.trim());
            }
            for (i = length; i < 3; ++i) {
                array[i] = last;
            }
            return array;
        }).orElseGet(() -> Arrays.copyOf(ColorUtils.getColorsPerRarity(context), 3));
    }

    public String getItemRating(ItemStack stack) {
        return this.itemRating.filter(rating -> !rating.trim().isEmpty()).orElse("W");
    }

    public int getItemRatingColor(TooltipContext context) {
        return this.colorItemRating.map(ConfigColorParser::parseColor).orElseGet(() -> ColorUtils.getFirstColorOfRarity(context));
    }

    public boolean shouldDisableDividerLine() {
        return this.disableDividerLine.orElse(TooltipsConfig.DISABLE_DIVIDER_LINE);
    }

    public boolean shouldDisableTooltip() {
        return this.disableTooltip.orElse(false);
    }

    public String getIconAppearAnimation() {
        return this.iconAppearAnimation.orElse(TooltipsConfig.ICON_APPEAR_ANIMATION);
    }

    public String getIconBackground() {
        return this.iconBackgroundType.orElse(TooltipsConfig.ICON_BACKGROUND_TYPE);
    }

    public boolean hasVignette() {
        return !this.vignettes.isEmpty();
    }

    public float getIconRotatingSpeed() {
        return this.iconRotatingSpeed.orElse(Float.valueOf(TooltipsConfig.ICON_ROTATING_SPEED)).floatValue();
    }

    public boolean getUsePlayerSkinInPreview() {
        return this.usePlayerSkinInPreview.orElse(TooltipsConfig.USE_PLAYER_SKIN_IN_PREVIEW);
    }

    public String getDividerLineType() {
        return this.dividerLineType.orElse(TooltipsConfig.DIVIDER_LINE_TYPE);
    }

    public String getPreviewPanelModel() {
        return this.previewPanelModel.orElse(TooltipsConfig.PREVIEW_PANEL_MODEL);
    }

    public int getDividerLineTopPadding() {
        return this.dividerLineTopPadding.orElse(TooltipsConfig.DIVIDER_LINE_TOP_PADDING);
    }

    public int getDividerLineBottomPadding() {
        return this.dividerLineBottomPadding.orElse(TooltipsConfig.DIVIDER_LINE_BOTTOM_PADDING);
    }

    public int getTooltipPositionX() {
        return this.tooltipPositionX.orElse(TooltipsConfig.TOOLTIP_POSITION_X);
    }

    public int getTooltipPositionY() {
        return this.tooltipPositionY.orElse(TooltipsConfig.TOOLTIP_POSITION_Y);
    }

    public int getBackgroundColor() {
        return this.backgroundColor.orElse(Palette.PANEL_BG);
    }

    public boolean shouldDisableScrolling() {
        return this.disableScrolling.orElse(TooltipsConfig.DISABLE_TOOLTIP_SCROLLING);
    }

    public boolean shouldShowShadow() {
        return this.showShadow.orElse(TooltipsConfig.SHOW_TOOLTIP_SHADOW);
    }

    public int getSecondPanelX() {
        return this.secondPanelX.orElse(TooltipsConfig.SECOND_PANEL_X);
    }

    public int getSecondPanelY() {
        return this.secondPanelY.orElse(TooltipsConfig.SECOND_PANEL_Y);
    }

    public int getSecondPanelSizeX() {
        return this.secondPanelSizeX.orElse(TooltipsConfig.SECOND_PANEL_SIZE_X);
    }

    public int getSecondPanelSizeY() {
        return this.secondPanelSizeY.orElse(TooltipsConfig.SECOND_PANEL_SIZE_Y);
    }

    public String getRatingAlignment() {
        return this.ratingAlignment.orElse(TooltipsConfig.RATING_X_ALIGNMENT);
    }

    public String getTitleAlignment() {
        return this.titleAlignment.orElse(TooltipsConfig.TITLE_X_ALIGNMENT);
    }

    public float getSecondPanelRendererSpeed() {
        return this.secondPanelRendererSpeed.orElse(Float.valueOf(TooltipsConfig.SECOND_PANEL_RENDERER_SPEED)).floatValue();
    }

    public String getEffect() {
        return this.specialEffect.orElse(TooltipsConfig.EFFECTS);
    }

    public List<ResourceLocation> getItemLocations() {
        return this.items.stream().map(ResourceLocation::parse).collect(Collectors.toList());
    }

    public List<TagKey<Item>> getTagKeys() {
        return this.tags.stream().map(name -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)name))).collect(Collectors.toList());
    }

    public boolean matches(ItemStack stack) {
        String namespace;
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (this.items.contains(key.toString())) {
            return true;
        }
        if (this.namespace.isPresent() && !(namespace = this.namespace.get().trim()).isEmpty()) {
            if (namespace.equals("*") || namespace.equalsIgnoreCase("all")) {
                return true;
            }
            if (key.getNamespace().equals(namespace)) {
                return true;
            }
        }
        for (TagKey<Item> tagKey : this.getTagKeys()) {
            if (!stack.is(tagKey)) continue;
            return true;
        }
        return false;
    }

    public int getMainPanelPaddingX() {
        return this.mainPanelPaddingX.orElse(TooltipsConfig.MAIN_PANEL_PADDING_X);
    }

    public int getMainPanelPaddingY() {
        return this.mainPanelPaddingY.orElse(TooltipsConfig.MAIN_PANEL_PADDING_Y);
    }

    public String getDividerLineColor() {
        return this.dividerLineColor.orElse(TooltipsConfig.DIVIDER_LINE_COLOR);
    }

    public boolean hasCustomTexture() {
        return this.texture.isPresent() && !this.texture.get().trim().isEmpty();
    }

    public boolean hasCustomItemRating() {
        return this.itemRating.isPresent() && !this.itemRating.get().trim().isEmpty();
    }

    public boolean shouldShowRating() {
        return this.showRating.orElse(TooltipsConfig.SHOW_RATING);
    }

    public boolean shouldDisableIcon() {
        return this.disableIcon.orElse(TooltipsConfig.DISABLE_ICON);
    }

    public boolean shouldShowSecondPanel(TooltipContext context) {
        if (context.getStack().getItem() instanceof TieredItem && this.showSecondPanel.orElse(TooltipsConfig.TIERED_ITEMS_RENDERER).booleanValue()) {
            return true;
        }
        return context.getStack().getItem() instanceof ArmorItem && this.showSecondPanel.orElse(TooltipsConfig.ARMOR_ITEMS_RENDERER) != false;
    }

    public boolean hasCustomColorItemRating() {
        return this.colorItemRating.isPresent();
    }

    public static enum GradientType {
        COMMON,
        UNCOMMON,
        RARE,
        EPIC,
        LEGENDARY,
        CHAOS,
        CUSTOM;

    }
}

