/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.config.ConfigManager;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.config.wrapper.ConfigEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class TooltipOverhaulConfigScreen
extends Screen {
    private final Screen parent;
    private ConfigPanel panel;
    private EditBox searchBox;
    private float searchHoverProgress = 0.0f;
    private static final int HEADER_HEIGHT = 64;

    public TooltipOverhaulConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Tooltip Overhaul Config"));
        this.parent = parent;
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    protected void init() {
        int panelTop = 72;
        int panelBottom = this.height - 40;
        int panelHeight = Math.max(0, panelBottom - panelTop);
        this.panel = new ConfigPanel(20, panelTop, this.width - 40, panelHeight);
        this.addRenderableWidget((GuiEventListener)this.panel);
        int searchWidth = 240;
        int searchX = this.panel.getX() + 10;
        int searchY = 38;
        this.searchBox = new CenteredEditBox(this.font, searchX, searchY, searchWidth, 20, (Component)Component.literal((String)"Search"));
        this.searchBox.setHint((Component)Component.literal((String)"Search settings..."));
        this.searchBox.setResponder(this::onSearchChanged);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(-1513240);
        this.searchBox.setTextColorUneditable(-8947849);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        for (Field field : TooltipsConfig.class.getDeclaredFields()) {
            ConfigEntry meta = field.getAnnotation(ConfigEntry.class);
            if (meta == null) continue;
            field.setAccessible(true);
            this.panel.addConfigEntry(field, meta);
        }
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 10;
        int totalWidth = buttonWidth * 2 + spacing;
        int startX = (this.width - totalWidth) / 2;
        int buttonY = this.height - 28;
        this.addRenderableWidget((GuiEventListener)new ConfigPanel.ModernButton(startX, buttonY, buttonWidth, buttonHeight, CommonComponents.GUI_DONE, b -> {
            this.saveConfig();
            this.minecraft.setScreen(this.parent);
        }));
        this.addRenderableWidget((GuiEventListener)new ConfigPanel.ModernButton(startX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight, (Component)Component.literal((String)"Cancel"), b -> this.minecraft.setScreen(this.parent)));
        this.panel.applySearch("");
    }

    private void onSearchChanged(String text) {
        if (this.panel != null) {
            this.panel.applySearch(text);
        }
    }

    private void saveConfig() {
        if (this.panel != null) {
            this.panel.applyToFields();
            ConfigManager.save(TooltipsConfig.class);
        }
    }

    public void tick() {
        if (this.panel != null) {
            this.panel.tickPanel();
        }
        super.tick();
    }

    public void onClose() {
        this.saveConfig();
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
        this.renderHeader(graphics);
        this.renderSearchBackground(graphics, mouseX, mouseY);
        this.renderFooterSeparator(graphics);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private void renderFooterSeparator(GuiGraphics graphics) {
        int lineW = (int)((float)this.width * 0.8f);
        int x0 = (this.width - lineW) / 2;
        int x1 = x0 + lineW;
        int y = this.height - 36;
        int h = 1;
        int red = 77;
        int green = 77;
        int blue = 77;
        int centerX = x0 + lineW / 2;
        PoseStack pose = graphics.pose();
        Matrix4f matrix = pose.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buffer.addVertex(matrix, (float)x0, (float)(y + h), 0.0f).setColor(red, green, blue, 0);
        buffer.addVertex(matrix, (float)centerX, (float)(y + h), 0.0f).setColor(red, green, blue, 255);
        buffer.addVertex(matrix, (float)centerX, (float)y, 0.0f).setColor(red, green, blue, 255);
        buffer.addVertex(matrix, (float)x0, (float)y, 0.0f).setColor(red, green, blue, 0);
        buffer.addVertex(matrix, (float)centerX, (float)(y + h), 0.0f).setColor(red, green, blue, 255);
        buffer.addVertex(matrix, (float)x1, (float)(y + h), 0.0f).setColor(red, green, blue, 0);
        buffer.addVertex(matrix, (float)x1, (float)y, 0.0f).setColor(red, green, blue, 0);
        buffer.addVertex(matrix, (float)centerX, (float)y, 0.0f).setColor(red, green, blue, 255);
        try (MeshData data = buffer.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
        RenderSystem.disableBlend();
    }

    private void renderHeader(GuiGraphics graphics) {
        for (int i = 0; i < 64; ++i) {
            int alpha = Math.max(0, 80 - i * 2);
            if (alpha <= 0) continue;
            int color = alpha << 24;
            graphics.fill(0, i, this.width, i + 1, color);
        }
        String brandTitle = "Tooltip Overhaul";
        int brandTitleWidth = this.font.width(brandTitle);
        int brandTitleX = this.width - 18 - brandTitleWidth;
        int brandTitleY = 10;
        graphics.drawString(this.font, brandTitle, brandTitleX, brandTitleY, -1, false);
        String brandSubtitle = "Every tooltip, more modern, sharper, cleaner.";
        int brandSubtitleWidth = this.font.width(brandSubtitle);
        int brandSubtitleX = this.width - 18 - brandSubtitleWidth;
        int brandSubtitleY = brandTitleY + 12;
        graphics.drawString(this.font, brandSubtitle, brandSubtitleX, brandSubtitleY, -5592406, false);
    }

    private void renderSearchBackground(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.searchBox == null) {
            return;
        }
        int boxX = this.searchBox.getX();
        int boxY = this.searchBox.getY();
        int boxW = this.searchBox.getWidth();
        int boxH = this.searchBox.getHeight();
        boolean hovered = mouseX >= boxX && mouseX <= boxX + boxW && mouseY >= boxY && mouseY <= boxY + boxH;
        boolean active = hovered || this.searchBox.isFocused();
        float step = 0.1f;
        this.searchHoverProgress = active ? Math.min(1.0f, this.searchHoverProgress + step) : Math.max(0.0f, this.searchHoverProgress - step);
        graphics.fill(boxX, boxY, boxX + boxW, boxY + boxH, 0x35353535);
        int baseBorder = 2;
        int extraBorder = Math.round(this.searchHoverProgress * 2.0f);
        int borderW = baseBorder + extraBorder;
        int idleBorder = 0x40FFFFFF;
        int hoverBorder = -11886849;
        int borderColor = this.searchHoverProgress > 0.0f ? hoverBorder : idleBorder;
        graphics.fill(boxX, boxY, boxX + borderW, boxY + boxH, borderColor);
        if (this.searchHoverProgress > 0.0f) {
            int gradientW = Math.min(120, boxW / 3);
            int maxA = (int)(64.0f * this.searchHoverProgress);
            PoseStack pose = graphics.pose();
            Matrix4f matrix = pose.last().pose();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            int x0 = boxX;
            int x1 = boxX + gradientW;
            int y0 = boxY;
            int y1 = boxY + boxH;
            bufferBuilder.addVertex(matrix, (float)x0, (float)y1, 0.0f).setColor(74, 158, 255, maxA);
            bufferBuilder.addVertex(matrix, (float)x1, (float)y1, 0.0f).setColor(74, 158, 255, 0);
            bufferBuilder.addVertex(matrix, (float)x1, (float)y0, 0.0f).setColor(74, 158, 255, 0);
            bufferBuilder.addVertex(matrix, (float)x0, (float)y0, 0.0f).setColor(74, 158, 255, maxA);
            try (MeshData data = bufferBuilder.buildOrThrow();){
                BufferUploader.drawWithShader((MeshData)data);
            }
            RenderSystem.disableBlend();
        }
    }

    static class ConfigPanel
    extends AbstractWidget {
        private final List<ValueEntry> allEntries = new ArrayList<ValueEntry>();
        private final List<ValueEntry> visibleEntries = new ArrayList<ValueEntry>();
        private double scrollAmount = 0.0;
        private double targetScroll = 0.0;
        private static final int ROW_GAP = 4;
        private boolean draggingScrollbar = false;
        private int dragThumbOffsetY = 0;
        private ValueEntry focusedEntry = null;

        public ConfigPanel(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
        }

        public void tickPanel() {
            for (ValueEntry valueEntry : this.visibleEntries) {
            }
        }

        public void addConfigEntry(Field field, ConfigEntry meta) {
            ValueEntry entry = new ValueEntry(field, meta);
            this.allEntries.add(entry);
            this.visibleEntries.add(entry);
            this.recalcLayout();
        }

        public void applySearch(String query) {
            this.visibleEntries.clear();
            ValueEntry prevFocused = this.focusedEntry;
            this.focusedEntry = null;
            if (query == null || query.isBlank()) {
                this.visibleEntries.addAll(this.allEntries);
            } else {
                String queryLowerCase = query.toLowerCase();
                for (ValueEntry valueEntry : this.allEntries) {
                    if (!valueEntry.matches(queryLowerCase)) continue;
                    this.visibleEntries.add(valueEntry);
                }
            }
            if (prevFocused != null && this.visibleEntries.contains(prevFocused)) {
                this.focusedEntry = prevFocused;
                this.focusedEntry.setFocused(true);
            } else if (prevFocused != null) {
                prevFocused.setFocused(false);
            }
            this.recalcLayout();
        }

        public void applyToFields() {
            for (ValueEntry entry : this.allEntries) {
                entry.applyToField();
            }
        }

        private int getContentWidth() {
            return this.width - 20;
        }

        private int getRowLeft() {
            return this.getX() + 10;
        }

        private void recalcLayout() {
            int rowWidth = this.getContentWidth();
            for (ValueEntry e : this.visibleEntries) {
                e.recalculateHeight(rowWidth);
            }
            this.clampScroll();
        }

        private int getTotalContentHeight() {
            int total = 4;
            boolean first = true;
            for (ValueEntry e : this.visibleEntries) {
                if (!first) {
                    total += 4;
                }
                total += e.getHeight();
                first = false;
            }
            return total;
        }

        private void clampScroll() {
            int innerHeight = this.height;
            int contentHeight = this.getTotalContentHeight();
            if (contentHeight <= innerHeight) {
                this.scrollAmount = 0.0;
                this.targetScroll = 0.0;
            } else {
                double maxScroll;
                if (this.targetScroll < 0.0) {
                    this.targetScroll = 0.0;
                }
                if (this.targetScroll > (maxScroll = (double)(contentHeight - innerHeight))) {
                    this.targetScroll = maxScroll;
                }
                if (this.scrollAmount < 0.0) {
                    this.scrollAmount = 0.0;
                }
                if (this.scrollAmount > maxScroll) {
                    this.scrollAmount = maxScroll;
                }
            }
        }

        private boolean isInside(double mouseX, double mouseY) {
            return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height);
        }

        private boolean hasScrollableContent() {
            return this.getTotalContentHeight() > this.height;
        }

        private ScrollbarGeom getScrollbarGeom() {
            int contentHeight = this.getTotalContentHeight();
            int left = this.getX();
            int top = this.getY();
            int right = left + this.width;
            int barWidth = 6;
            int trackX0 = right - barWidth;
            int trackX1 = right;
            double maxScroll = Math.max(0.0, (double)(contentHeight - this.height));
            double scrollRatio = maxScroll <= 0.0 ? 0.0 : this.scrollAmount / maxScroll;
            double visibleRatio = (double)this.height / (double)contentHeight;
            int thumbH = (int)((double)this.height * visibleRatio);
            if (thumbH < 24) {
                thumbH = 24;
            }
            if (thumbH > this.height) {
                thumbH = this.height;
            }
            int thumbY = top + (int)((double)(this.height - thumbH) * scrollRatio);
            return new ScrollbarGeom(trackX0, trackX1, top, top + this.height, thumbY, thumbY + thumbH, thumbH, maxScroll);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (!this.visible) {
                return;
            }
            if (!this.draggingScrollbar && this.scrollAmount != this.targetScroll) {
                double diff = this.targetScroll - this.scrollAmount;
                this.scrollAmount = Math.abs(diff) < 0.5 ? this.targetScroll : (this.scrollAmount += diff * 0.2);
                this.clampScroll();
            }
            int left = this.getX();
            int top = this.getY();
            int right = left + this.width;
            int bottom = top + this.height;
            guiGraphics.fill(left, top, right, bottom, -15658735);
            guiGraphics.enableScissor(left, top, right, bottom);
            int rowLeft = this.getRowLeft();
            int rowWidth = this.getContentWidth();
            int currentY = top + 4 - (int)this.scrollAmount;
            int index = 0;
            boolean first = true;
            for (ValueEntry valueEntry : this.visibleEntries) {
                int rowTop;
                int rowBottom;
                int rowHeight = valueEntry.getHeight();
                if (!first) {
                    currentY += 4;
                }
                if ((rowBottom = (rowTop = currentY) + rowHeight) >= top && rowTop <= bottom) {
                    boolean mouseInPanel = mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
                    boolean hovered = mouseInPanel && mouseX >= rowLeft && mouseX <= rowLeft + rowWidth && mouseY >= rowTop && mouseY <= rowBottom;
                    valueEntry.render(guiGraphics, index, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered, partialTick);
                }
                currentY += rowHeight;
                ++index;
                first = false;
            }
            guiGraphics.disableScissor();
            this.renderScrollbar(guiGraphics);
        }

        private void renderScrollbar(GuiGraphics guiGraphics) {
            if (!this.hasScrollableContent()) {
                return;
            }
            ScrollbarGeom scrollbarGeom = this.getScrollbarGeom();
            guiGraphics.fill(scrollbarGeom.trackX0, scrollbarGeom.trackTop, scrollbarGeom.trackX1, scrollbarGeom.trackBottom, Integer.MIN_VALUE);
            guiGraphics.fill(scrollbarGeom.trackX0, scrollbarGeom.thumbTop, scrollbarGeom.trackX1, scrollbarGeom.thumbBottom, -11886849);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (!this.visible) {
                return false;
            }
            if (!this.isInside(mouseX, mouseY)) {
                return false;
            }
            if (!this.hasScrollableContent()) {
                return false;
            }
            this.draggingScrollbar = false;
            this.targetScroll -= verticalAmount * 20.0;
            this.clampScroll();
            return true;
        }

        private void clearFocus() {
            if (this.focusedEntry != null) {
                this.focusedEntry.setFocused(false);
                this.focusedEntry = null;
            }
        }

        private void setFocus(ValueEntry entry) {
            if (this.focusedEntry == entry) {
                return;
            }
            if (this.focusedEntry != null) {
                this.focusedEntry.setFocused(false);
            }
            this.focusedEntry = entry;
            if (this.focusedEntry != null) {
                this.focusedEntry.setFocused(true);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.visible || !this.active) {
                return false;
            }
            if (!this.isInside(mouseX, mouseY)) {
                return false;
            }
            if (this.hasScrollableContent()) {
                ScrollbarGeom scrollbarGeom = this.getScrollbarGeom();
                if (mouseX >= (double)scrollbarGeom.trackX0 && mouseX <= (double)scrollbarGeom.trackX1) {
                    if (mouseY >= (double)scrollbarGeom.thumbTop && mouseY <= (double)scrollbarGeom.thumbBottom) {
                        this.draggingScrollbar = true;
                        this.dragThumbOffsetY = (int)mouseY - scrollbarGeom.thumbTop;
                        return true;
                    }
                    double time = (mouseY - (double)scrollbarGeom.trackTop) / (double)(scrollbarGeom.trackBottom - scrollbarGeom.trackTop);
                    time = Math.max(0.0, Math.min(1.0, time));
                    double desired = time * scrollbarGeom.maxScroll - (double)this.height * 0.5;
                    this.scrollAmount = this.targetScroll = Math.max(0.0, Math.min(scrollbarGeom.maxScroll, desired));
                    this.clampScroll();
                    return true;
                }
            }
            int top = this.getY();
            int rowLeft = this.getRowLeft();
            int rowWidth = this.getContentWidth();
            int currentY = top + 4 - (int)this.scrollAmount;
            boolean first = true;
            for (ValueEntry entry : this.visibleEntries) {
                int rowHeight = entry.getHeight();
                if (!first) {
                    currentY += 4;
                }
                int rowTop = currentY;
                int rowBottom = rowTop + rowHeight;
                if (mouseY >= (double)rowTop && mouseY <= (double)rowBottom && mouseX >= (double)rowLeft && mouseX <= (double)(rowLeft + rowWidth)) {
                    if (entry.mouseClicked(mouseX, mouseY, button)) {
                        this.setFocus(entry);
                        return true;
                    }
                    this.clearFocus();
                    return true;
                }
                currentY += rowHeight;
                first = false;
            }
            this.clearFocus();
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.visible || !this.active) {
                return false;
            }
            if (this.draggingScrollbar && this.hasScrollableContent()) {
                ScrollbarGeom scrollbarGeom = this.getScrollbarGeom();
                int trackSpan = scrollbarGeom.trackBottom - scrollbarGeom.trackTop - scrollbarGeom.thumbHeight;
                if (trackSpan <= 0) {
                    return true;
                }
                int desiredThumbTop = (int)mouseY - this.dragThumbOffsetY;
                int minThumbTop = scrollbarGeom.trackTop;
                int maxThumbTop = scrollbarGeom.trackBottom - scrollbarGeom.thumbHeight;
                desiredThumbTop = Math.max(minThumbTop, Math.min(maxThumbTop, desiredThumbTop));
                double t = (double)(desiredThumbTop - minThumbTop) / (double)(maxThumbTop - minThumbTop);
                this.scrollAmount = this.targetScroll = t * scrollbarGeom.maxScroll;
                this.clampScroll();
                return true;
            }
            return this.focusedEntry != null && this.focusedEntry.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.draggingScrollbar) {
                this.draggingScrollbar = false;
                return true;
            }
            if (this.focusedEntry != null) {
                return this.focusedEntry.mouseReleased(mouseX, mouseY, button);
            }
            return false;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (this.focusedEntry != null && this.focusedEntry.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean charTyped(char codePoint, int modifiers) {
            if (this.focusedEntry != null && this.focusedEntry.charTyped(codePoint, modifiers)) {
                return true;
            }
            return super.charTyped(codePoint, modifiers);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        private static class ValueEntry {
            private final Field field;
            private final Component label;
            private final String commentText;
            private final AbstractWidget valueWidget;
            private final boolean colorField;
            private final String searchIndex;
            private float hoverProgress = 0.0f;
            private int height = 40;
            private final Random particleRng;
            private final ArrayList<HoverParticle> hoverParticles = new ArrayList();
            private long lastParticleSpawnMs = 0L;
            private long lastParticleUpdateMs = 0L;
            private static final int PARTICLE_CAP = 22;

            public ValueEntry(Field field, ConfigEntry meta) {
                this.field = field;
                this.colorField = ValueEntry.isColorField(field, meta);
                String prettyLabel = ValueEntry.buildLabel(meta, field.getName());
                this.label = Component.literal((String)prettyLabel);
                this.commentText = meta.comment().trim();
                String raw = field.getName() + " " + field.getName().replace('_', ' ') + " " + prettyLabel + " " + meta.category() + " " + this.commentText;
                this.searchIndex = ValueEntry.normalizeForSearch(raw);
                this.valueWidget = this.createWidget();
                int seed = (field.getName() + "|" + meta.category() + "|" + meta.note()).hashCode();
                this.particleRng = new Random(seed);
                this.lastParticleUpdateMs = System.currentTimeMillis();
            }

            public int getHeight() {
                return this.height;
            }

            public void setFocused(boolean focused) {
                this.valueWidget.setFocused(focused);
                AbstractWidget abstractWidget = this.valueWidget;
                if (abstractWidget instanceof EditBox) {
                    EditBox box = (EditBox)abstractWidget;
                    box.setFocused(focused);
                }
            }

            public void recalculateHeight(int rowWidth) {
                Minecraft minecraft = Minecraft.getInstance();
                int PAD_TOP = 6;
                int LABEL_GAP = 3;
                Objects.requireNonNull(minecraft.font);
                int LINE_H = 9;
                int widgetW = this.valueWidget.getWidth();
                int labelXRelative = 8;
                int available = rowWidth - widgetW - 10 - labelXRelative - 16;
                int commentMaxWidth = Math.min(available, (int)((float)rowWidth * 0.45f));
                int commentLines = 0;
                if (!this.commentText.isEmpty() && commentMaxWidth > 40) {
                    commentLines = minecraft.font.split((FormattedText)Component.literal((String)this.commentText), commentMaxWidth).size();
                }
                int height = PAD_TOP + Math.max(this.valueWidget.getHeight(), LINE_H);
                if (commentLines > 0) {
                    height += LABEL_GAP + commentLines * LINE_H;
                }
                this.height = height;
            }

            private static boolean isColorField(Field field, ConfigEntry meta) {
                String name = field.getName().toLowerCase();
                if (name.contains("color") || name.contains("colour") || name.contains("palette")) {
                    return true;
                }
                if (meta != null) {
                    String note = meta.note().toLowerCase();
                    String comment = meta.comment().toLowerCase();
                    if (note.contains("color") || note.contains("colour") || note.contains("hex") || comment.contains("color") || comment.contains("palette") || comment.contains("argb")) {
                        return true;
                    }
                }
                return false;
            }

            private static String buildLabel(ConfigEntry meta, String fieldName) {
                String prettyName = ValueEntry.prettifyName(fieldName);
                String category = meta.category().trim();
                if (!category.isEmpty()) {
                    String catPretty = ValueEntry.prettifyName(category);
                    return catPretty + " \u203a " + prettyName;
                }
                return prettyName;
            }

            private static String prettifyName(String name) {
                String lower = name.toLowerCase().replace('$', ' ').replace('_', ' ');
                String[] parts = lower.split("\\s+");
                StringBuilder out = new StringBuilder();
                for (String part : parts) {
                    if (part.isEmpty()) continue;
                    if (out.length() > 0) {
                        out.append(' ');
                    }
                    out.append(Character.toUpperCase(part.charAt(0)));
                    if (part.length() <= 1) continue;
                    out.append(part.substring(1));
                }
                return out.toString();
            }

            private AbstractWidget createWidget() {
                Minecraft minecraft = Minecraft.getInstance();
                Class<?> type = this.field.getType();
                try {
                    if (type == Boolean.TYPE) {
                        boolean value = this.field.getBoolean(null);
                        return new ModernCheckbox(0, 0, 20, 20, (Component)Component.empty(), value);
                    }
                    if (type == Integer.TYPE && this.colorField) {
                        int value = this.field.getInt(null);
                        ModernEditBox box = new ModernEditBox(minecraft.font, 0, 0, 100, 20, (Component)Component.empty());
                        box.setMaxLength(64);
                        box.setValue(ValueEntry.formatColor(value));
                        return box;
                    }
                    String value = String.valueOf(this.field.get(null));
                    boolean isMultiColor = type == String.class && value.contains(",") && (value.contains("0x") || value.contains("#"));
                    int boxWidth = isMultiColor ? 260 : 180;
                    ModernEditBox box = new ModernEditBox(minecraft.font, 0, 0, boxWidth, 20, (Component)Component.empty());
                    box.setMaxLength(512);
                    box.setValue(value);
                    return box;
                }
                catch (Exception expection) {
                    ModernEditBox box = new ModernEditBox(Minecraft.getInstance().font, 0, 0, 180, 20, (Component)Component.empty());
                    box.setMaxLength(512);
                    box.setValue("");
                    return box;
                }
            }

            private static String formatColor(int argb) {
                return String.format("#%08X", argb);
            }

            public boolean matches(String query) {
                String normalizedQuery = ValueEntry.normalizeForSearch(query);
                if (normalizedQuery.isEmpty()) {
                    return true;
                }
                for (String token : normalizedQuery.split(" ")) {
                    if (token.isEmpty() || this.searchIndex.contains(token)) continue;
                    return false;
                }
                return true;
            }

            private static String normalizeForSearch(String string) {
                if (string == null) {
                    return "";
                }
                String out = string.toLowerCase();
                out = out.replace('_', ' ').replace('-', ' ').replace('.', ' ').replace('/', ' ');
                out = out.trim().replaceAll("\\s+", " ");
                return out;
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.valueWidget.mouseClicked(mouseX, mouseY, button);
            }

            public boolean mouseReleased(double mouseX, double mouseY, int button) {
                return this.valueWidget.mouseReleased(mouseX, mouseY, button);
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
                return this.valueWidget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                return this.valueWidget.keyPressed(keyCode, scanCode, modifiers);
            }

            public boolean charTyped(char codePoint, int modifiers) {
                return this.valueWidget.charTyped(codePoint, modifiers);
            }

            public void applyToField() {
                try {
                    Class<?> type = this.field.getType();
                    if (type == Boolean.TYPE) {
                        AbstractWidget abstractWidget = this.valueWidget;
                        if (abstractWidget instanceof Checkbox) {
                            Checkbox cb = (Checkbox)abstractWidget;
                            this.field.setBoolean(null, cb.selected());
                        }
                        return;
                    }
                    AbstractWidget abstractWidget = this.valueWidget;
                    if (!(abstractWidget instanceof EditBox)) {
                        return;
                    }
                    EditBox box = (EditBox)abstractWidget;
                    String raw = box.getValue();
                    String trimmed = raw.trim();
                    if (type == String.class) {
                        this.field.set(null, raw);
                        return;
                    }
                    if (trimmed.isEmpty()) {
                        return;
                    }
                    if (type == Integer.TYPE) {
                        int current = this.field.getInt(null);
                        int value = this.colorField ? ValueEntry.parseColorInt(trimmed, current) : ValueEntry.parseIntFlexible(trimmed, current);
                        this.field.setInt(null, value);
                    } else if (type == Long.TYPE) {
                        long current = this.field.getLong(null);
                        long value = ValueEntry.parseLongFlexible(trimmed, current);
                        this.field.setLong(null, value);
                    } else if (type == Float.TYPE) {
                        try {
                            this.field.setFloat(null, Float.parseFloat(trimmed));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (type == Double.TYPE) {
                        try {
                            this.field.setDouble(null, Double.parseDouble(trimmed));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private static int parseIntFlexible(String text, int fallback) {
                try {
                    Object string = text.trim();
                    if (((String)string).startsWith("0x") || ((String)string).startsWith("0X") || ((String)string).startsWith("#")) {
                        if (((String)string).startsWith("#")) {
                            string = "0x" + ((String)string).substring(1);
                        }
                        return Integer.decode((String)string);
                    }
                    return Integer.parseInt((String)string);
                }
                catch (Exception ignored) {
                    return fallback;
                }
            }

            private static long parseLongFlexible(String txt, long fallback) {
                try {
                    Object string = txt.trim();
                    if (((String)string).startsWith("0x") || ((String)string).startsWith("0X") || ((String)string).startsWith("#")) {
                        if (((String)string).startsWith("#")) {
                            string = "0x" + ((String)string).substring(1);
                        }
                        return Long.decode((String)string);
                    }
                    return Long.parseLong((String)string);
                }
                catch (Exception ignored) {
                    return fallback;
                }
            }

            private static int parseColorInt(String txt, int fallback) {
                try {
                    String string = txt.trim();
                    if (string.isEmpty()) {
                        return fallback;
                    }
                    if (string.startsWith("#")) {
                        string = string.substring(1);
                    }
                    if (string.startsWith("0x") || string.startsWith("0X")) {
                        string = string.substring(2);
                    }
                    if (string.length() == 6) {
                        long rgb = Long.parseLong(string, 16) & 0xFFFFFFL;
                        long argb = 0xFF000000L | rgb;
                        return (int)argb;
                    }
                    long argb = Long.parseLong(string, 16);
                    return (int)argb;
                }
                catch (Exception ignored) {
                    return fallback;
                }
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                int available;
                int commentMaxWidth;
                Minecraft minecraft = Minecraft.getInstance();
                float step = 0.1f;
                this.hoverProgress = hovered ? Math.min(1.0f, this.hoverProgress + step) : Math.max(0.0f, this.hoverProgress - step);
                int baseAlpha = index % 2 == 0 ? 40 : 32;
                int extraAlpha = (int)(48.0f * this.hoverProgress);
                int totalAlpha = Math.min(255, baseAlpha + extraAlpha);
                int bgColor = totalAlpha << 24 | 0x353535;
                guiGraphics.fill(left, top, left + width, top + height, bgColor);
                int gradientWidth = Math.min(120, width / 3);
                if (this.hoverProgress > 0.0f) {
                    int maxAlpha = (int)(64.0f * this.hoverProgress);
                    for (int x = 0; x < gradientWidth; ++x) {
                        float t = (float)x / (float)gradientWidth;
                        int a = (int)((float)maxAlpha * (1.0f - t));
                        if (a <= 0) continue;
                        int color = a << 24 | 0x4A9EFF;
                        int x1 = left + x;
                        guiGraphics.fill(x1, top, x1 + 1, top + height, color);
                    }
                }
                int baseBorderWidth = 2;
                int extraBorder = Math.round(this.hoverProgress * 2.0f);
                int borderWidth = baseBorderWidth + extraBorder;
                int idleColor = 0x40FFFFFF;
                int hoverColor = -11886849;
                int borderColor = this.hoverProgress > 0.0f ? hoverColor : idleColor;
                guiGraphics.fill(left, top, left + borderWidth, top + height, borderColor);
                guiGraphics.fill(left, top + height - 1, left + width, top + height, 0x20000000);
                this.updateHoverParticles(top, height);
                if (this.hoverProgress > 0.15f) {
                    this.spawnHoverParticles(left, top, width, height, borderWidth, gradientWidth, this.hoverProgress);
                }
                this.renderHoverParticles(guiGraphics, this.hoverProgress);
                int labelX = left + 8;
                int labelY = top + 6;
                guiGraphics.drawString(minecraft.font, this.label, labelX + 1, labelY + 1, Integer.MIN_VALUE, false);
                guiGraphics.drawString(minecraft.font, this.label, labelX, labelY, -1, false);
                int widgetWidth = this.valueWidget.getWidth();
                int widgetHeight = this.valueWidget.getHeight();
                int widgetX = left + width - widgetWidth - 10;
                int widgetY = top + (height - widgetHeight) / 2;
                this.valueWidget.setX(widgetX);
                this.valueWidget.setY(widgetY);
                if (this.colorField && this.field.getType() == Integer.TYPE) {
                    try {
                        int color = this.field.getInt(null);
                        int previewSize = 18;
                        int previewRight = widgetX - 8;
                        int previewLeft = previewRight - previewSize;
                        int previewTop = top + (height - previewSize) / 2;
                        this.drawCheckerboard(guiGraphics, previewLeft, previewTop, previewSize, previewSize);
                        guiGraphics.fill(previewLeft, previewTop, previewRight, previewTop + previewSize, color);
                        guiGraphics.fill(previewLeft - 1, previewTop - 1, previewRight + 1, previewTop, -10461088);
                        guiGraphics.fill(previewLeft - 1, previewTop + previewSize, previewRight + 1, previewTop + previewSize + 1, -13619152);
                        guiGraphics.fill(previewLeft - 1, previewTop - 1, previewLeft, previewTop + previewSize + 1, -10461088);
                        guiGraphics.fill(previewRight, previewTop - 1, previewRight + 1, previewTop + previewSize + 1, -13619152);
                    }
                    catch (IllegalAccessException color) {
                        // empty catch block
                    }
                }
                this.valueWidget.render(guiGraphics, mouseX, mouseY, partialTick);
                AbstractWidget previewSize = this.valueWidget;
                if (previewSize instanceof EditBox) {
                    EditBox box = (EditBox)previewSize;
                    this.renderInlineColorBars(guiGraphics, box);
                }
                if (!this.commentText.isEmpty() && (commentMaxWidth = Math.min(available = widgetX - labelX - 16, (int)((float)width * 0.45f))) > 40) {
                    Objects.requireNonNull(minecraft.font);
                    int lineHeight = 9;
                    Objects.requireNonNull(minecraft.font);
                    int commentY = labelY + 9 + 3;
                    List lines = minecraft.font.split((FormattedText)Component.literal((String)this.commentText), commentMaxWidth);
                    int availableHeight = top + height - commentY;
                    int maxLines = Math.max(1, availableHeight / lineHeight);
                    int drawn = 0;
                    for (FormattedCharSequence line : lines) {
                        if (drawn >= maxLines) break;
                        guiGraphics.drawString(minecraft.font, line, labelX, commentY, -6250336, false);
                        commentY += lineHeight;
                        ++drawn;
                    }
                }
            }

            private static List<Integer> extractColorsFromText(String text) {
                if (text == null) {
                    return Collections.emptyList();
                }
                String string = text.trim();
                if (string.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<Integer> out = new ArrayList<Integer>();
                Pattern prefixed = Pattern.compile("(?:#|0x|0X)([0-9a-fA-F]{8}|[0-9a-fA-F]{6})");
                Matcher matcher = prefixed.matcher(string);
                while (matcher.find()) {
                    String hex = matcher.group(1);
                    Integer color = ValueEntry.parseHexColorToken(hex);
                    if (color == null) continue;
                    out.add(color);
                }
                if (out.isEmpty()) {
                    Pattern bare = Pattern.compile("(?<![0-9a-fA-F])([0-9a-fA-F]{8}|[0-9a-fA-F]{6})(?![0-9a-fA-F])");
                    Matcher matcher2 = bare.matcher(string);
                    while (matcher2.find()) {
                        Integer color;
                        String token = matcher2.group(1);
                        boolean hasLetter = token.chars().anyMatch(ch -> ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102);
                        if (!hasLetter || (color = ValueEntry.parseHexColorToken(token)) == null) continue;
                        out.add(color);
                    }
                }
                return out;
            }

            private static Integer parseHexColorToken(String hex) {
                try {
                    if (hex.length() == 6) {
                        int rgb = (int)(Long.parseLong(hex, 16) & 0xFFFFFFL);
                        return 0xFF000000 | rgb;
                    }
                    if (hex.length() == 8) {
                        return (int)(Long.parseLong(hex, 16) & 0xFFFFFFFFL);
                    }
                    return null;
                }
                catch (Exception ignored) {
                    return null;
                }
            }

            private void renderInlineColorBars(GuiGraphics g, EditBox box) {
                List<Integer> colors = ValueEntry.extractColorsFromText(box.getValue());
                if (colors.isEmpty()) {
                    return;
                }
                int max = Math.min(colors.size(), 8);
                int bx = box.getX();
                int by = box.getY();
                int bw = box.getWidth();
                int bh = box.getHeight();
                int padRight = 3;
                int padY = 3;
                int barW = 4;
                int gap = 2;
                int stripW = max * barW + (max - 1) * gap;
                int x1 = bx + bw - padRight;
                int x0 = x1 - stripW;
                int y0 = by + padY;
                int y1 = by + bh - padY;
                for (int i = 0; i < max; ++i) {
                    int c = colors.get(i);
                    int px0 = x0 + i * (barW + gap);
                    int px1 = px0 + barW;
                    this.drawMiniChecker(g, px0, y0, barW, y1 - y0);
                    g.fill(px0, y0, px1, y1, c);
                }
            }

            private void drawMiniChecker(GuiGraphics graphics, int x, int y, int w, int h) {
                int cs = 2;
                for (int yy = 0; yy < h; yy += cs) {
                    for (int xx = 0; xx < w; xx += cs) {
                        boolean light = (xx / cs + yy / cs) % 2 == 0;
                        int col = light ? -5197648 : -8750470;
                        int dx = Math.min(cs, w - xx);
                        int dy = Math.min(cs, h - yy);
                        graphics.fill(x + xx, y + yy, x + xx + dx, y + yy + dy, col);
                    }
                }
            }

            private void updateHoverParticles(int rowTop, int rowHeight) {
                long now = System.currentTimeMillis();
                long timeMs = Math.min(33L, Math.max(0L, now - this.lastParticleUpdateMs));
                this.lastParticleUpdateMs = now;
                float dateTime = timeMs;
                for (int i = this.hoverParticles.size() - 1; i >= 0; --i) {
                    HoverParticle particle = this.hoverParticles.get(i);
                    particle.ageMs += dateTime;
                    particle.x += particle.vx * dateTime;
                    particle.y = particle.baseY + (float)Math.sin(particle.phase + particle.ageMs * particle.freq) * particle.amp;
                    if (particle.ageMs >= particle.lifeMs) {
                        this.hoverParticles.remove(i);
                        continue;
                    }
                    if (!(particle.y < (float)(rowTop - 6)) && !(particle.y > (float)(rowTop + rowHeight + 6))) continue;
                    this.hoverParticles.remove(i);
                }
            }

            private void spawnHoverParticles(int left, int top, int width, int height, int borderW, int gradientW, float hoverProgress) {
                int minInterval;
                int maxInterval;
                int interval;
                long now = System.currentTimeMillis();
                if (now - this.lastParticleSpawnMs < (long)(interval = (int)((float)(maxInterval = 85) - (float)(maxInterval - (minInterval = 35)) * hoverProgress))) {
                    return;
                }
                this.lastParticleSpawnMs = now;
                if (this.hoverParticles.size() >= 22) {
                    return;
                }
                int count = hoverProgress > 0.6f && this.particleRng.nextFloat() < 0.55f ? 2 : 1;
                for (int n = 0; n < count && this.hoverParticles.size() < 22; ++n) {
                    int blue;
                    int green;
                    int red;
                    boolean white;
                    float spawnX = (float)(left + borderW - 1) + this.particleRng.nextFloat() * 2.0f;
                    float spawnY = (float)(top + 6) + this.particleRng.nextFloat() * (float)(height - 12);
                    float vx = 0.02f + this.particleRng.nextFloat() * 0.045f;
                    float amp = 0.6f + this.particleRng.nextFloat() * 1.2f;
                    float frequency = 0.01f + this.particleRng.nextFloat() * 0.01f;
                    float phase = this.particleRng.nextFloat() * 6.28318f;
                    float size = 1.0f + this.particleRng.nextFloat() * 1.2f;
                    float life = 420.0f + this.particleRng.nextFloat() * 360.0f;
                    boolean bl = white = this.particleRng.nextFloat() < 0.28f;
                    if (white) {
                        red = 235;
                        green = 245;
                        blue = 255;
                        vx *= 1.08f;
                    } else {
                        red = 74;
                        green = 158;
                        blue = 255;
                    }
                    this.hoverParticles.add(new HoverParticle(spawnX, spawnY, vx, spawnY, amp, frequency, phase, size, red, green, blue, life));
                }
            }

            private void renderHoverParticles(GuiGraphics graphics, float hoverProgress) {
                if (this.hoverParticles.isEmpty()) {
                    return;
                }
                float intensity = Math.min(1.0f, 0.65f + hoverProgress * 0.55f);
                for (HoverParticle particle : this.hoverParticles) {
                    int alpha;
                    float time = particle.ageMs / particle.lifeMs;
                    float fade = 1.0f - time;
                    if ((alpha = (int)((fade *= fade) * 190.0f * intensity)) <= 2) continue;
                    int color = alpha << 24 | particle.red << 16 | particle.green << 8 | particle.blue;
                    int x0 = (int)particle.x;
                    int y0 = (int)particle.y;
                    int size = Math.max(1, (int)particle.size);
                    graphics.fill(x0, y0, x0 + size, y0 + size, color);
                    int trailA = alpha / 3;
                    if (trailA <= 0) continue;
                    int trail = trailA << 24 | particle.red << 16 | particle.green << 8 | particle.blue;
                    graphics.fill(x0 - 1, y0, x0, y0 + size, trail);
                }
            }

            private void drawCheckerboard(GuiGraphics graphics, int x, int y, int width, int height) {
                int checkerSize = 4;
                for (int cy = 0; cy < height; cy += checkerSize) {
                    for (int cx = 0; cx < width; cx += checkerSize) {
                        boolean isLight = (cx / checkerSize + cy / checkerSize) % 2 == 0;
                        int color = isLight ? -3355444 : -6710887;
                        int drawWidth = Math.min(checkerSize, width - cx);
                        int drawHeight = Math.min(checkerSize, height - cy);
                        graphics.fill(x + cx, y + cy, x + cx + drawWidth, y + cy + drawHeight, color);
                    }
                }
            }

            private static class HoverParticle {
                float x;
                float y;
                float vx;
                float baseY;
                float amp;
                float freq;
                float phase;
                float size;
                int red;
                int green;
                int blue;
                float lifeMs;
                float ageMs;

                HoverParticle(float x, float y, float vx, float baseY, float amp, float freq, float phase, float size, int red, int green, int blue, float lifeMs) {
                    this.x = x;
                    this.y = y;
                    this.vx = vx;
                    this.baseY = baseY;
                    this.amp = amp;
                    this.freq = freq;
                    this.phase = phase;
                    this.size = size;
                    this.red = red;
                    this.green = green;
                    this.blue = blue;
                    this.lifeMs = lifeMs;
                    this.ageMs = 0.0f;
                }
            }
        }

        private record ScrollbarGeom(int trackX0, int trackX1, int trackTop, int trackBottom, int thumbTop, int thumbBottom, int thumbHeight, double maxScroll) {
        }

        static class ModernButton
        extends Button {
            private float animationProgress = 0.0f;

            public ModernButton(int x, int y, int w, int h, Component msg, Button.OnPress onPress) {
                super(x, y, w, h, msg, onPress, Button.DEFAULT_NARRATION);
            }

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                int x0 = this.getX();
                int y0 = this.getY();
                int x1 = x0 + this.getWidth();
                int y1 = y0 + this.getHeight();
                boolean hovered = mouseX >= x0 && mouseX < x1 && mouseY >= y0 && mouseY < y1;
                boolean active = hovered || this.isFocused();
                float step = 0.16f;
                this.animationProgress = active ? Math.min(1.0f, this.animationProgress + step) : Math.max(0.0f, this.animationProgress - step);
                int backgroundOuter = -15461356;
                int backgroundInner = hovered ? -14803426 : -15132391;
                graphics.fill(x0, y0, x1, y1, backgroundOuter);
                graphics.fill(x0 + 1, y0 + 1, x1 - 1, y1 - 1, backgroundInner);
                int baseBorder = 2;
                int extraBorder = Math.round(this.animationProgress * 2.0f);
                int borderW = baseBorder + extraBorder;
                int idleBorder = 0x40FFFFFF;
                int hoverBorder = -11886849;
                int borderColor = this.animationProgress > 0.0f ? hoverBorder : idleBorder;
                graphics.fill(x0, y0, x0 + borderW, y1, borderColor);
                if (this.animationProgress > 0.0f) {
                    int gradientW = Math.min(90, this.getWidth() / 3);
                    int maxA = (int)(64.0f * this.animationProgress);
                    for (int x = 0; x < gradientW; ++x) {
                        float time = (float)x / (float)gradientW;
                        int alpha = (int)((float)maxA * (1.0f - time));
                        if (alpha <= 0) continue;
                        int color = alpha << 24 | 0x4A9EFF;
                        graphics.fill(x0 + x, y0, x0 + x + 1, y1, color);
                    }
                }
                int outline = hovered ? -13750738 : -14408668;
                graphics.fill(x0, y0, x1, y0 + 1, outline);
                graphics.fill(x0, y1 - 1, x1, y1, outline);
                graphics.fill(x0, y0, x0 + 1, y1, outline);
                graphics.fill(x1 - 1, y0, x1, y1, outline);
                int txt = this.active ? -1513240 : -8947849;
                int ty = y0 + (this.height - 8) / 2;
                graphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), x0 + this.width / 2, ty, txt);
            }
        }

        private static class ModernEditBox
        extends EditBox {
            private float animationProgress = 0.0f;

            public ModernEditBox(Font font, int x, int y, int w, int h, Component msg) {
                super(font, x, y, w, h, msg);
                this.setBordered(false);
                this.setTextColor(-1513240);
                this.setTextColorUneditable(-8947849);
                this.setMaxLength(512);
            }

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                int x0 = this.getX();
                int y0 = this.getY();
                int x1 = x0 + this.getWidth();
                int y1 = y0 + this.getHeight();
                boolean hovered = mouseX >= x0 && mouseX < x1 && mouseY >= y0 && mouseY < y1;
                boolean active = hovered || this.isFocused();
                float step = 0.16f;
                this.animationProgress = active ? Math.min(1.0f, this.animationProgress + step) : Math.max(0.0f, this.animationProgress - step);
                graphics.fill(x0, y0, x1, y1, -15329770);
                graphics.fill(x0 + 1, y0 + 1, x1 - 1, y1 - 1, -14803426);
                int borderIdle = -12961222;
                int borderFocus = -11886849;
                int border = this.animationProgress > 0.0f ? borderFocus : borderIdle;
                graphics.fill(x0, y0, x1, y0 + 1, border);
                graphics.fill(x0, y1 - 1, x1, y1, border);
                graphics.fill(x0, y0, x0 + 1, y1, border);
                graphics.fill(x1 - 1, y0, x1, y1, border);
                Objects.requireNonNull(Minecraft.getInstance().font);
                int lh = 9;
                int offY = Math.max(0, (this.height - lh) / 2);
                int padX = 6;
                graphics.pose().pushPose();
                graphics.pose().translate((float)padX, (float)(offY + 1), 0.0f);
                super.renderWidget(graphics, mouseX - padX, mouseY - offY, partialTick);
                graphics.pose().popPose();
            }
        }

        private static class ModernCheckbox
        extends Checkbox {
            public ModernCheckbox(int x, int y, int w, int h, Component msg, boolean selected) {
                super(x, y, w, msg, Minecraft.getInstance().font, selected, (cb, val) -> {});
            }

            public void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
                boolean hovered = this.isHoveredOrFocused();
                int size = Math.min(this.getWidth(), this.getHeight());
                int x0 = this.getX();
                int y0 = this.getY();
                int x1 = x0 + this.getWidth();
                int y1 = y0 + this.getHeight();
                int backgroundColor = -15198184;
                g.fill(x0, y0, x1, y1, backgroundColor);
                int border = hovered ? -11886849 : -12961222;
                g.fill(x0, y0, x1, y0 + 1, border);
                g.fill(x0, y1 - 1, x1, y1, border);
                g.fill(x0, y0, x0 + 1, y1, border);
                g.fill(x1 - 1, y0, x1, y1, border);
                if (this.selected()) {
                    int inset = Math.max(3, size / 5);
                    int inner = -11886849;
                    g.fill(x0 + inset, y0 + inset, x1 - inset, y1 - inset, inner);
                }
            }
        }
    }

    private static class CenteredEditBox
    extends EditBox {
        public CenteredEditBox(Font font, int x, int y, int width, int height, Component text) {
            super(font, x, y, width, height, text);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            int leftHeight = 9;
            int offset = Math.max(0, (this.height - leftHeight) / 2);
            graphics.pose().pushPose();
            graphics.pose().translate(8.0f, (float)(offset + 1), 0.0f);
            super.renderWidget(graphics, mouseX, mouseY - offset, partialTick);
            graphics.pose().popPose();
        }
    }
}

