/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style;

import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.layer.ITooltipLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.style.background.DefaultBackground;
import dev.xylonity.tooltipoverhaul.client.style.badge.DefaultEquippedBadge;
import dev.xylonity.tooltipoverhaul.client.style.divider.GradientDividerLine;
import dev.xylonity.tooltipoverhaul.client.style.divider.LinearDividerLine;
import dev.xylonity.tooltipoverhaul.client.style.divider.StaticDividerLine;
import dev.xylonity.tooltipoverhaul.client.style.effect.CinderEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.EchoEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.GalaxyEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.MagicOrbsEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.MetalShiningEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.NebulaEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.RimLightEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.RipplesEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.SonarEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.SpeedLinesEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.StarsEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.TimeSpiralEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.WhiteDustEffect;
import dev.xylonity.tooltipoverhaul.client.style.icon.DefaultIcon;
import dev.xylonity.tooltipoverhaul.client.style.icon.background.FocusIconBackground;
import dev.xylonity.tooltipoverhaul.client.style.icon.background.GlowingIconBackground;
import dev.xylonity.tooltipoverhaul.client.style.icon.background.SlotBorderIconBackground;
import dev.xylonity.tooltipoverhaul.client.style.icon.background.SlotIconBackground;
import dev.xylonity.tooltipoverhaul.client.style.icon.background.VoidIconBackground;
import dev.xylonity.tooltipoverhaul.client.style.inner.GradientInnerOverlay;
import dev.xylonity.tooltipoverhaul.client.style.inner.StaticInnerOverlay;
import dev.xylonity.tooltipoverhaul.client.style.overlay.DefaultOverlay;
import dev.xylonity.tooltipoverhaul.client.style.preview.background.DefaultPreviewBackground;
import dev.xylonity.tooltipoverhaul.client.style.preview.inner.DefaultPreviewGradientInnerOverlay;
import dev.xylonity.tooltipoverhaul.client.style.preview.renderer.DefaultPreviewArmorStand;
import dev.xylonity.tooltipoverhaul.client.style.preview.renderer.DefaultPreviewPlayerRenderer;
import dev.xylonity.tooltipoverhaul.client.style.preview.renderer.DefaultPreviewStackRenderer;
import dev.xylonity.tooltipoverhaul.client.style.shadow.DefaultShadow;
import dev.xylonity.tooltipoverhaul.client.style.text.DefaultText;
import dev.xylonity.tooltipoverhaul.client.style.vignette.CircularHoleVignette;
import dev.xylonity.tooltipoverhaul.client.style.vignette.CircularVignette;
import dev.xylonity.tooltipoverhaul.client.style.vignette.parser.VignetteEntry;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import dev.xylonity.tooltipoverhaul.client.util.Palette;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import java.util.ArrayList;
import java.util.List;

public class StyleFactory {
    public List<ITooltipLayer> create(TooltipContext context, CustomFrameData data) {
        if (context.getStack().isEmpty()) {
            return this.createEmpty(context);
        }
        if (data != null) {
            return this.createCustom(context);
        }
        return this.createForRarity(context);
    }

    private List<ITooltipLayer> createEmpty(TooltipContext context) {
        ArrayList<ITooltipLayer> layers = new ArrayList<ITooltipLayer>();
        layers.add(new DefaultBackground());
        layers.add(new DefaultText());
        int[] colors = Palette.NO_STACK;
        layers.add(new GradientInnerOverlay(colors[0], colors[1], colors[2]));
        return layers;
    }

    private List<ITooltipLayer> createCustom(TooltipContext context) {
        ArrayList<ITooltipLayer> layers = new ArrayList<ITooltipLayer>();
        int[] colors = ColorUtils.getInnerOverlayColors(context);
        this.assignDefaultLayers(context, layers, colors);
        boolean hasVignette = RenderUtils.hasVignette(context);
        if (hasVignette) {
            List<String> rawVignetteEntries = context.getFrameData().vignettes();
            if (!rawVignetteEntries.isEmpty()) {
                StringBuilder rawKeys = new StringBuilder();
                for (String rawVignette : rawVignetteEntries) {
                    rawKeys.append(rawVignette).append(",");
                }
                this.parseVignetteEntries(rawKeys.toString(), layers);
            } else {
                this.parseVignetteEntries(TooltipsConfig.VIGNETTES, layers);
            }
        }
        layers.add(new DefaultOverlay());
        this.assignEffects(context, layers, colors);
        return layers;
    }

    private List<ITooltipLayer> createForRarity(TooltipContext context) {
        ArrayList<ITooltipLayer> layers = new ArrayList<ITooltipLayer>();
        int[] colors = ColorUtils.getColorsPerRarity(context);
        this.assignDefaultLayers(context, layers, colors);
        boolean hasVignette = RenderUtils.hasVignette(context);
        if (hasVignette) {
            this.parseVignetteEntries(TooltipsConfig.VIGNETTES, layers);
        }
        layers.add(new DefaultOverlay());
        this.assignEffects(context, layers, colors);
        return layers;
    }

    private void assignDefaultLayers(TooltipContext context, List<ITooltipLayer> layers, int[] colors) {
        layers.add(new DefaultBackground());
        layers.add(new DefaultText());
        if (RenderUtils.hasShadow(context)) {
            layers.add(new DefaultShadow());
        }
        switch (RenderUtils.getInnerOverlayType(context)) {
            case "glint": 
            case "auto_glint": {
                layers.add(new GradientInnerOverlay(colors[0], colors[1], 0));
                break;
            }
            case "static": 
            case "auto_static": {
                layers.add(new StaticInnerOverlay(colors[0]));
                break;
            }
            default: {
                layers.add(new GradientInnerOverlay(colors[0], colors[1], colors[2]));
            }
        }
        if (context.hasIcon()) {
            String iconBackgroundType;
            switch (iconBackgroundType = RenderUtils.getIconBackgroundType(context)) {
                case "focus": {
                    layers.add(new FocusIconBackground());
                    break;
                }
                case "void": {
                    layers.add(new VoidIconBackground());
                    break;
                }
                case "slot": {
                    layers.add(new SlotIconBackground());
                    break;
                }
                case "slot_border": {
                    layers.add(new SlotBorderIconBackground());
                    break;
                }
                case "glow": {
                    layers.add(new GlowingIconBackground());
                }
            }
            layers.add(new DefaultIcon());
        }
        if (context.hasDividerLine() && context.getComponents().size() > 1) {
            String dividerLineType;
            switch (dividerLineType = RenderUtils.getDividerLineType(context)) {
                case "gradient": {
                    layers.add(new GradientDividerLine());
                    break;
                }
                case "static": {
                    layers.add(new StaticDividerLine());
                    break;
                }
                case "linear": {
                    layers.add(new LinearDividerLine());
                }
            }
        }
        boolean hasPreviewOfTieredItem = RenderUtils.hasPreviewOfTieredItem(context);
        boolean hasPreviewOfArmorItem = RenderUtils.hasPreviewOfArmorItem(context);
        if (hasPreviewOfTieredItem || hasPreviewOfArmorItem) {
            layers.add(new DefaultPreviewBackground());
            layers.add(new DefaultPreviewGradientInnerOverlay(colors[0], colors[1], colors[2]));
            if (hasPreviewOfTieredItem) {
                layers.add(new DefaultPreviewStackRenderer());
            } else if (RenderUtils.getPreviewPanelModel(context).equals("armor_stand")) {
                layers.add(new DefaultPreviewArmorStand());
            } else {
                layers.add(new DefaultPreviewPlayerRenderer());
            }
        }
        if (!context.isMainTooltip()) {
            layers.add(new DefaultEquippedBadge(colors[0], colors[1], colors[2]));
        }
    }

    private void parseVignetteEntries(String key, List<ITooltipLayer> layers) {
        List<VignetteEntry> vignetteEntries = VignetteEntry.Parser.from(key);
        for (VignetteEntry entry : vignetteEntries) {
            switch (entry.type()) {
                case "circular": {
                    layers.add(new CircularVignette(entry));
                    break;
                }
                case "hole": {
                    layers.add(new CircularHoleVignette(entry));
                }
            }
        }
    }

    private void assignEffects(TooltipContext context, List<ITooltipLayer> layers, int[] colors) {
        block30: for (String part : RenderUtils.getEffect(context).split("\\s*[;,]\\s*")) {
            switch (part.trim().toLowerCase()) {
                case "cinder": {
                    layers.add(new CinderEffect());
                    continue block30;
                }
                case "echo": {
                    layers.add(new EchoEffect());
                    continue block30;
                }
                case "galaxy": {
                    layers.add(new GalaxyEffect());
                    continue block30;
                }
                case "magic_orbs": {
                    layers.add(new MagicOrbsEffect());
                    continue block30;
                }
                case "speed_lines": {
                    layers.add(new SpeedLinesEffect());
                    continue block30;
                }
                case "nebula": {
                    layers.add(new NebulaEffect());
                    continue block30;
                }
                case "spiral": {
                    layers.add(new TimeSpiralEffect());
                    continue block30;
                }
                case "white_dust": {
                    layers.add(new WhiteDustEffect());
                    continue block30;
                }
                case "metal_shining": {
                    layers.add(new MetalShiningEffect());
                    continue block30;
                }
                case "rim_light": {
                    layers.add(new RimLightEffect(-2011870087, 0));
                    continue block30;
                }
                case "ripples": {
                    layers.add(new RipplesEffect());
                    continue block30;
                }
                case "sonar": {
                    layers.add(new SonarEffect());
                    continue block30;
                }
                case "stars": {
                    layers.add(new StarsEffect());
                }
            }
        }
    }
}

