/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import java.util.Random;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class NebulaEffect
implements EffectLayer {
    private static final int NEBULA_COLOR_1 = 1627054070;
    private static final int NEBULA_COLOR_2 = 1082836881;
    private static final int NEBULA_COLOR_3 = 1344950675;
    private static final int STAR_COLOR_CORE = -1;
    private static final int STAR_COLOR_GLOW = -2136290049;
    private static final int ENERGY_WAVE_COLOR = 1358932735;
    private static final int PARTICLE_COUNT = 10;
    private static final int SEGMENTS = 96;
    private static final float[][] PARTICLE_DATA = new float[10][5];

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int positionX = (int)position.x;
        int positionY = (int)position.y;
        int tooltipWidth = (int)context.getTooltipSize().x;
        int tooltipHeight = (int)context.getTooltipSize().y;
        long now = System.currentTimeMillis();
        float time = (float)(now - context.getStartTime()) / 8000.0f;
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float maxRadius = (float)Math.hypot(tooltipWidth, tooltipHeight) * 0.85f;
        context.push(() -> {
            context.getGraphics().enableScissor(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            context.translate(0.0f, 0.0f, context.getLayerDepth().getZ());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f pose = context.getPose().last().pose();
            Tesselator tesselator = Tesselator.getInstance();
            this.renderNebulaLayers(tesselator, pose, centerX, centerY, maxRadius, tooltipWidth, tooltipHeight, time);
            this.renderSideWaves(tesselator, pose, centerX, centerY, maxRadius, time);
            this.renderParticles(tesselator, pose, positionX, positionY, tooltipWidth, tooltipHeight, centerX, centerY, maxRadius, time);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().disableScissor();
        });
    }

    private void renderNebulaLayers(Tesselator tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, int width, int height, float time) {
        float aspect = (float)height / (float)Math.max(1, width);
        int[] colors = new int[]{1627054070, 1082836881, 1344950675};
        float[] ringOffsets = new float[]{0.6f, 0.75f, 0.92f};
        float[] ringThickness = new float[]{0.2f, 0.18f, 0.16f};
        float[] speeds = new float[]{0.5f, -0.35f, 0.22f};
        for (int layer = 0; layer < 3; ++layer) {
            int color = colors[layer];
            float baseRadius = maxRadius * ringOffsets[layer];
            float thickness = maxRadius * ringThickness[layer];
            float halfTh = thickness * 0.5f;
            float phase = time * ((float)Math.PI * 2) * speeds[layer];
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i <= 96; ++i) {
                float s = (float)i / 96.0f;
                float angle = s * ((float)Math.PI * 2) + phase;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float swirl1 = 0.12f * (float)Math.sin(angle * 3.0f + phase * 2.1f + (float)layer * 0.7f);
                float swirl2 = 0.07f * (float)Math.sin(angle * 7.0f - phase * 1.4f);
                float swirl = (swirl1 + swirl2) * maxRadius;
                float ringRadius = baseRadius + swirl;
                float inner = ringRadius - halfTh * 0.4f;
                float outer = ringRadius + halfTh * 0.4f;
                float sxInner = cos * inner;
                float syInner = sin * inner * aspect;
                float sxOuter = cos * outer;
                float syOuter = sin * outer * aspect;
                float ix = centerX + sxInner;
                float iy = centerY + syInner;
                float ox = centerX + sxOuter;
                float oy = centerY + syOuter;
                float vertical = (float)Math.max(0.0, (double)(sin * 0.8f + 0.2f));
                float band = 0.5f + 0.5f * (float)Math.sin(angle * 2.0f - phase * 1.3f + (float)layer);
                float intensity = vertical * (0.4f + 0.6f * band);
                int innerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * intensity * 0.95f));
                int outerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * intensity * 0.7f));
                bufferBuilder.addVertex(pose, ox, oy, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), outerA);
                bufferBuilder.addVertex(pose, ix, iy, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), innerA);
            }
            try (MeshData data = bufferBuilder.buildOrThrow();){
                BufferUploader.drawWithShader((MeshData)data);
            }
            BufferBuilder bufferBuilder1 = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i <= 96; ++i) {
                float s = (float)i / 96.0f;
                float angle = s * ((float)Math.PI * 2) + phase;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float swirl1 = 0.12f * (float)Math.sin(angle * 3.0f + phase * 2.1f + (float)layer * 0.7f);
                float swirl2 = 0.07f * (float)Math.sin(angle * 7.0f - phase * 1.4f);
                float swirl = (swirl1 + swirl2) * maxRadius;
                float ringRadius = baseRadius + swirl;
                float inner = ringRadius + halfTh * 0.4f;
                float outer = ringRadius + halfTh;
                float sxInner = cos * inner;
                float syInner = sin * inner * aspect;
                float sxOuter = cos * outer;
                float syOuter = sin * outer * aspect;
                float ix = centerX + sxInner;
                float iy = centerY + syInner;
                float ox = centerX + sxOuter;
                float oy = centerY + syOuter;
                float horizontalMask = (float)Math.pow(Math.abs(sin), 1.4f);
                float band = 0.5f + 0.5f * (float)Math.sin(angle * 2.0f - phase * 1.3f + (float)layer);
                float intensity = horizontalMask * (0.35f + 0.65f * band);
                int innerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * intensity * 0.3f));
                int outerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * intensity * 0.04f));
                bufferBuilder1.addVertex(pose, ox, oy, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), outerA);
                bufferBuilder1.addVertex(pose, ix, iy, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), innerA);
            }
            try (MeshData data = bufferBuilder1.buildOrThrow();){
                BufferUploader.drawWithShader((MeshData)data);
            }
            BufferBuilder bufferBuilder2 = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i <= 96; ++i) {
                float s = (float)i / 96.0f;
                float angle = s * ((float)Math.PI * 2) + phase;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float swirl1 = 0.12f * (float)Math.sin(angle * 3.0f + phase * 2.1f + (float)layer * 0.7f);
                float swirl2 = 0.07f * (float)Math.sin(angle * 7.0f - phase * 1.4f);
                float swirl = (swirl1 + swirl2) * maxRadius;
                float ringRadius = baseRadius + swirl;
                float inner = ringRadius - halfTh;
                float outer = ringRadius - halfTh * 0.4f;
                float sxInner = cos * inner;
                float syInner = sin * inner * aspect;
                float sxOuter = cos * outer;
                float syOuter = sin * outer * aspect;
                float ix = centerX + sxInner;
                float iy = centerY + syInner;
                float ox = centerX + sxOuter;
                float oy = centerY + syOuter;
                float horizontalMask = (float)Math.pow(Math.abs(sin), 1.4f);
                float band = 0.5f + 0.5f * (float)Math.sin(angle * 2.0f - phase * 1.3f + (float)layer);
                float intensity = horizontalMask * (0.35f + 0.65f * band);
                int innerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * intensity * 0.04f));
                int outerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * intensity * 0.3f));
                bufferBuilder2.addVertex(pose, ox, oy, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), outerA);
                bufferBuilder2.addVertex(pose, ix, iy, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), innerA);
            }
            try (MeshData data = bufferBuilder2.buildOrThrow();){
                BufferUploader.drawWithShader((MeshData)data);
                continue;
            }
        }
    }

    private void renderSideWaves(Tesselator tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        for (int band = 0; band < 2; ++band) {
            float bandOffset = band == 0 ? 0.0f : (float)Math.PI;
            float phase = time * ((float)Math.PI * 2) * (0.35f + (float)band * 0.18f);
            float radius = maxRadius * (0.58f + (float)band * 0.1f);
            float thickness = maxRadius * (0.06f + (float)band * 0.02f);
            float arcSpan = 4.3982296f;
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i <= 96; ++i) {
                float s = (float)i / 96.0f;
                float local = (s - 0.5f) * arcSpan;
                float angle = local + phase + bandOffset;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float wobble = 0.08f * (float)Math.sin(s * 6.0f + time * (float)Math.PI * 4.0f + (float)band * 1.7f);
                float baseRadius = radius + wobble * maxRadius * 0.18f;
                float inner = baseRadius - thickness * 0.5f;
                float outer = baseRadius + thickness * 0.5f;
                float ix = centerX + cos * inner;
                float iy = centerY + sin * inner;
                float ox = centerX + cos * outer;
                float oy = centerY + sin * outer;
                float arcMask = (float)Math.sin((double)s * Math.PI);
                float pulse = 0.6f + 0.4f * (float)Math.sin(time * (float)Math.PI * 2.0f * 3.0f + s * 5.0f + (float)band * 1.3f);
                float alphaF = arcMask * pulse;
                int edgeAlpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(1358932735) * alphaF * 0.4f));
                int coreAlpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(1358932735) * alphaF * 0.9f));
                bufferBuilder.addVertex(pose, ox, oy, 0.0f).setColor(ColorUtils.red(1358932735), ColorUtils.green(1358932735), ColorUtils.blue(1358932735), edgeAlpha);
                bufferBuilder.addVertex(pose, ix, iy, 0.0f).setColor(ColorUtils.red(1358932735), ColorUtils.green(1358932735), ColorUtils.blue(1358932735), coreAlpha);
            }
            try (MeshData data = bufferBuilder.buildOrThrow();){
                BufferUploader.drawWithShader((MeshData)data);
                continue;
            }
        }
    }

    private void renderParticles(Tesselator tesselator, Matrix4f pose, int x, int y, int width, int height, float centerX, float centerY, float maxRadius, float time) {
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float aspect = (float)height / (float)Math.max(1, width);
        float ringRadius = maxRadius * 0.68f;
        float ringThickness = maxRadius * 0.06f;
        for (int i = 0; i < 10; ++i) {
            float[] data = PARTICLE_DATA[i];
            float seedAngle = data[0] * ((float)Math.PI * 2);
            float seedRadOffset = data[1] - 0.5f;
            float phase = data[2];
            float speed = data[3];
            float sizeSeed = data[4];
            float angle = seedAngle + time * ((float)Math.PI * 2) * speed;
            float arm = (float)Math.sin(angle * 3.0f + phase);
            float radius = ringRadius + seedRadOffset * ringThickness * 3.0f + arm * ringThickness * 0.7f;
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float px = centerX + cos * radius;
            float py = centerY + sin * radius * aspect;
            float twinkle = 0.35f + 0.65f * (float)Math.pow(Math.sin(time * (float)Math.PI * 2.0f * speed + phase) * 0.5 + 0.5, 2.0);
            float size = sizeSeed * (0.7f + twinkle * 0.9f);
            int alpha = AnimationUtils.clamp255((int)(255.0f * twinkle));
            int color = i % 3 == 0 ? -1 : -2136290049;
            float half = size * 0.5f;
            bufferBuilder.addVertex(pose, px, py - half, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha);
            bufferBuilder.addVertex(pose, px + half, py, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha);
            bufferBuilder.addVertex(pose, px, py + half, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha);
            bufferBuilder.addVertex(pose, px - half, py, 0.0f).setColor(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha);
        }
        try (MeshData data = bufferBuilder.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    static {
        Random random = new Random(12345L);
        for (int i = 0; i < 10; ++i) {
            NebulaEffect.PARTICLE_DATA[i][0] = random.nextFloat();
            NebulaEffect.PARTICLE_DATA[i][1] = random.nextFloat();
            NebulaEffect.PARTICLE_DATA[i][2] = random.nextFloat() * ((float)Math.PI * 2);
            NebulaEffect.PARTICLE_DATA[i][3] = 0.3f + random.nextFloat() * 0.7f;
            NebulaEffect.PARTICLE_DATA[i][4] = 0.5f + random.nextFloat() * 1.5f;
        }
    }
}

