/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.icon.animation;

import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.style.icon.animation.IIconAnimation;
import dev.xylonity.tooltipoverhaul.client.style.icon.animation.IconAnimation;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import java.util.HashMap;
import java.util.Map;

public class IconAnimationFactory {
    private static final Map<IconAnimation, IIconAnimation> ANIMATIONS = new HashMap<IconAnimation, IIconAnimation>();

    public static IIconAnimation get(IconAnimation animation) {
        return ANIMATIONS.getOrDefault((Object)animation, (context, progress, scale) -> context.scale(scale, scale, scale));
    }

    private static void animateZoom(TooltipContext context, float progress, float scale) {
        float easedProgress = AnimationUtils.easeOutQuint(progress);
        float animationScale = easedProgress * scale;
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateRotate(TooltipContext context, float progress, float scale) {
        context.multiply(Axis.YP, 180.0f * progress);
        context.scale(scale, scale, scale);
    }

    private static void animateRotateFast(TooltipContext context, float progress, float scale) {
        context.multiply(Axis.YP, 360.0f * progress);
        context.scale(scale, scale, scale);
    }

    private static void animateRotateZoom(TooltipContext context, float progress, float scale) {
        context.multiply(Axis.YP, 180.0f * progress);
        IconAnimationFactory.animateZoom(context, progress, scale);
    }

    private static void animateZoomSnap(TooltipContext context, float progress, float scale) {
        float abs = progress < 0.72f ? 1.1f + 0.7f * AnimationUtils.easeOutCubic(progress / 0.72f) : 1.8f - 0.3f * AnimationUtils.smoothstep(0.0f, 1.0f, (progress - 0.72f) / 0.28f);
        float animationScale = IconAnimationFactory.scaled(abs, scale);
        context.multiply(Axis.YP, 4.0f * (1.0f - progress));
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateSkew(TooltipContext context, float progress, float scale) {
        float tilt = 18.0f * (1.0f - progress);
        context.multiply(Axis.XP, tilt);
        context.multiply(Axis.YP, -tilt * 0.6f);
        float undershoot = 0.12f * (1.0f - progress);
        float overshoot = 0.2f * (float)Math.sin(Math.PI * (double)progress);
        float animationScale = scale * (1.0f - undershoot + overshoot);
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateVibration(TooltipContext context, float progress, float scale) {
        float decay = 1.0f - progress;
        context.translate(1.2f * decay * (float)Math.sin(progress * 30.0f), 1.0f * decay * (float)Math.cos(progress * 27.0f), 0.0f);
        float abs = 1.4f + 0.1f * (1.0f - progress);
        float animationScale = IconAnimationFactory.scaled(abs, scale);
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateTiltWave(TooltipContext context, float progress, float scale) {
        float amp = 16.0f * (1.0f - progress);
        float waves = (float)Math.sin((double)progress * Math.PI * 6.0);
        context.multiply(Axis.ZP, amp * waves);
        context.multiply(Axis.XP, 0.6f * amp * waves);
        context.scale(scale, scale, scale);
    }

    private static void animateFlip(TooltipContext context, float progress, float scale) {
        context.multiply(Axis.XP, (1.0f - (float)(1.0 - Math.pow(1.0f - progress, 2.2))) * 90.0f);
        float undershoot = 0.12f * (1.0f - progress);
        float overshoot = 0.22f * (float)Math.sin(Math.PI * (double)progress);
        float animationScale = scale * (1.0f - undershoot + overshoot);
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animatePendulum(TooltipContext context, float progress, float scale) {
        context.translate(0.0f, -8.0f, 0.0f);
        context.multiply(Axis.ZP, 28.0f * (float)Math.cos((double)progress * Math.PI * 3.0) * (1.0f - progress));
        context.translate(0.0f, 8.0f, 0.0f);
        context.scale(scale, scale, scale);
    }

    private static void animateBounce(TooltipContext context, float progress, float scale) {
        context.translate(0.0f, AnimationUtils.dampBounce(progress, 3.0f, 8.0f), 0.0f);
        float abs = 1.45f + 0.05f * (float)Math.sin((double)progress * Math.PI);
        float animationScale = IconAnimationFactory.scaled(abs, scale);
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateGoDown(TooltipContext context, float progress, float scale) {
        context.translate(0.0f, -20.0f * (1.0f - AnimationUtils.easeOutCubic(progress)), 0.0f);
        context.multiply(Axis.ZP, (1.0f - progress) * -12.0f);
        float animationScale = scale - 0.08f * (1.0f - progress);
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animatePulse(TooltipContext context, float progress, float scale) {
        float pulses = (float)Math.sin((double)progress * Math.PI * 4.0);
        float abs = 1.5f + 0.25f * (1.0f - progress) * pulses;
        float animationScale = IconAnimationFactory.scaled(abs, scale);
        context.multiply(Axis.XP, 5.0f * pulses * (1.0f - progress));
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateFanIn(TooltipContext context, float progress, float scale) {
        context.multiply(Axis.YP, 32.0f * (float)Math.sin((double)progress * Math.PI * 5.0) * (1.0f - progress));
        float undershoot = 0.12f * (1.0f - progress);
        float overshoot = 0.18f * (float)Math.sin(Math.PI * (double)progress);
        float animationScale = scale * (1.0f - undershoot + overshoot);
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateHoverPop(TooltipContext context, float progress, float scale) {
        context.translate(0.0f, -(6.0f * (1.0f - AnimationUtils.easeOutCubic(progress))), 0.0f);
        float animationScale = 1.35f + 0.2f * AnimationUtils.smoothstep(0.6f, 1.0f, progress);
        context.multiply(Axis.XP, 6.0f * (1.0f - progress));
        context.scale(animationScale, animationScale, animationScale);
    }

    private static void animateBarrelRoll(TooltipContext context, float progress, float scale) {
        context.multiply(Axis.ZP, 360.0f * AnimationUtils.easeOutCubic(progress));
        float abs = 0.9f + 0.6f * AnimationUtils.easeOutCubic(progress);
        float animationScale = IconAnimationFactory.scaled(abs, scale);
        context.scale(animationScale, animationScale, animationScale);
    }

    private static float scaled(float value, float baseScale) {
        return baseScale * (value / 1.5f);
    }

    static {
        ANIMATIONS.put(IconAnimation.ZOOM, IconAnimationFactory::animateZoom);
        ANIMATIONS.put(IconAnimation.ROTATE, IconAnimationFactory::animateRotate);
        ANIMATIONS.put(IconAnimation.ROTATE_FAST, IconAnimationFactory::animateRotateFast);
        ANIMATIONS.put(IconAnimation.ROTATE_ZOOM, IconAnimationFactory::animateRotateZoom);
        ANIMATIONS.put(IconAnimation.ZOOM_SNAP, IconAnimationFactory::animateZoomSnap);
        ANIMATIONS.put(IconAnimation.SKEW, IconAnimationFactory::animateSkew);
        ANIMATIONS.put(IconAnimation.VIBRATION, IconAnimationFactory::animateVibration);
        ANIMATIONS.put(IconAnimation.TILT_WAVE, IconAnimationFactory::animateTiltWave);
        ANIMATIONS.put(IconAnimation.FLIP, IconAnimationFactory::animateFlip);
        ANIMATIONS.put(IconAnimation.PENDULUM, IconAnimationFactory::animatePendulum);
        ANIMATIONS.put(IconAnimation.BOUNCE, IconAnimationFactory::animateBounce);
        ANIMATIONS.put(IconAnimation.GO_DOWN, IconAnimationFactory::animateGoDown);
        ANIMATIONS.put(IconAnimation.PULSE, IconAnimationFactory::animatePulse);
        ANIMATIONS.put(IconAnimation.FAN_IN, IconAnimationFactory::animateFanIn);
        ANIMATIONS.put(IconAnimation.HOVER_POP, IconAnimationFactory::animateHoverPop);
        ANIMATIONS.put(IconAnimation.BARREL_ROLL, IconAnimationFactory::animateBarrelRoll);
    }
}

