/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.preview.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.layer.impl.PreviewRendererLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public class DefaultPreviewArmorStand
implements PreviewRendererLayer {
    @Override
    public void render(TooltipContext context, Vec2 startPosition, Vec2 endPosition) {
        Item item;
        int sizeX = RenderUtils.calculateSecondPanelSize(context, TextAxis.X);
        int sizeY = RenderUtils.calculateSecondPanelSize(context, TextAxis.Y);
        int y0 = (int)startPosition.y;
        int x1 = (int)endPosition.x;
        context.translate((float)x1 + (float)sizeX / 2.0f + 2.0f, (float)y0 + (float)sizeY / 1.15f + 2.0f, 0.0f);
        context.multiply(Axis.XP, -30.0f);
        context.multiply(Axis.YP, -45.0f);
        context.multiply(Axis.YP, (float)(System.currentTimeMillis() - context.getStartTime()) / 20.0f % 360.0f * AnimationUtils.getSecondPanelRendererSpeed(context));
        float scale = Math.min((float)sizeX, (float)sizeY / 2.0f) / 1.25f;
        context.scale(-scale, -scale, scale);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null && (item = context.getStack().getItem()) instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ArmorStand armorStand = new ArmorStand(EntityType.ARMOR_STAND, (Level)minecraft.level);
            armorStand.setNoBasePlate(true);
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                armorStand.setItemSlot(equipmentSlot, ItemStack.EMPTY);
            }
            armorStand.setItemSlot(armorItem.getEquipmentSlot(), context.getStack());
            Lighting.setupForEntityInInventory();
            EntityRenderDispatcher renderer = Minecraft.getInstance().getEntityRenderDispatcher();
            renderer.setRenderShadow(false);
            renderer.render((Entity)armorStand, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.getPose(), context.getBuffer(), 0xF000F0);
            renderer.setRenderShadow(true);
        }
    }
}

