/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.text;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.xylonity.tooltipoverhaul.client.layer.impl.TextLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import dev.xylonity.tooltipoverhaul.client.util.PositionUtils;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextUtils;
import dev.xylonity.tooltipoverhaul.client.util.TooltipScrollState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec2;

public class DefaultText
implements TextLayer {
    @Override
    public void render(TooltipContext context, Vec2 position) {
        List<ClientTooltipComponent> components = context.getComponents();
        Font font = context.getFont();
        PoseStack poseStack = context.getPose();
        GuiGraphics graphics = context.getGraphics();
        boolean hasIcon = context.hasIcon();
        boolean hasDividerLine = context.hasDividerLine();
        boolean hasRating = RenderUtils.hasRating(context);
        int paddingX = context.getPaddingX();
        int paddingY = context.getPaddingY();
        int x = (int)(position.x + (float)paddingX);
        int y = (int)(position.y + (float)paddingY + 1.0f);
        ClientTooltipComponent titleComponent = components.get(0);
        if (titleComponent != null) {
            int extraX = 0;
            int extraY = 0;
            int titleAlignY = 0;
            int ratingAlignY = 0;
            if (hasIcon) {
                extraX = Constants.getIconSize(context) + Constants.getIconTitleSeparation(context);
                extraY = Constants.getIconSize(context) / 2;
                titleAlignY = hasRating ? titleComponent.getHeight() : Constants.getIconSize(context) / 4;
            } else {
                ratingAlignY = titleComponent.getHeight();
            }
            int titleAlignment = this.computeTitleAlignment(context, titleComponent, x + extraX);
            titleComponent.renderText(font, x + extraX + titleAlignment, y + extraY - titleAlignY, poseStack.last().pose(), graphics.bufferSource());
            if (hasRating) {
                Component rating = TextUtils.getRatingText(context);
                int ratingAlignment = this.computeRatingAlignment(context, rating, x + extraX);
                context.getGraphics().drawString(font, TextUtils.getRatingText(context), x + extraX + ratingAlignment, y + extraY + ratingAlignY, 15588982, false);
                y += ClientTooltipComponent.create((FormattedCharSequence)rating.getVisualOrderText()).getHeight();
            } else if (hasIcon) {
                y += titleComponent.getHeight();
            }
            y += titleComponent.getHeight();
        }
        if (hasIcon) {
            y += Constants.getIconTitleSeparation(context);
        }
        if (hasDividerLine && components.size() > 1) {
            y = hasIcon ? (y += Constants.getDividerLineFullPadding(context)) : (y += Constants.getDividerLineFullPadding(context));
        }
        int contentStartY = y;
        if (TooltipScrollState.isIsActive()) {
            graphics.flush();
            Minecraft minecraft = Minecraft.getInstance();
            int guiScale = (int)minecraft.getWindow().getGuiScale();
            int scissorLeft = (int)position.x + paddingX;
            int scissorRight = (int)position.x + (int)context.getTooltipSize().x - paddingX;
            int scissorBottom = (int)position.y + (int)context.getTooltipSize().y - paddingY;
            int windowHeight = minecraft.getWindow().getHeight();
            int scaledLeft = scissorLeft * guiScale;
            int scaledTop = windowHeight - scissorBottom * guiScale;
            int scaledWidth = (scissorRight - scissorLeft) * guiScale;
            int scaledHeight = (scissorBottom - contentStartY) * guiScale;
            GlStateManager._enableScissorTest();
            GlStateManager._scissorBox((int)scaledLeft, (int)scaledTop, (int)scaledWidth, (int)scaledHeight);
            y -= TooltipScrollState.getScroll();
        }
        for (int i = 1; i < components.size(); ++i) {
            ClientTooltipComponent component = components.get(i);
            if (!TooltipScrollState.isIsActive() || y + component.getHeight() >= contentStartY && y <= (int)(position.y + context.getTooltipSize().y - (float)paddingY)) {
                component.renderText(font, x, y, poseStack.last().pose(), graphics.bufferSource());
                component.renderImage(font, x, y, graphics);
            }
            y += component.getHeight();
        }
        if (TooltipScrollState.isIsActive()) {
            graphics.flush();
            GlStateManager._disableScissorTest();
        }
    }

    private int computeTitleAlignment(TooltipContext context, ClientTooltipComponent component, int startX) {
        return switch (PositionUtils.getTitleTextAlignment(context)) {
            case "middle" -> {
                int tooltipSizeX = (int)context.getTooltipSize().x;
                int tooltipPositionX = (int)context.getTooltipPosition().x;
                int total = tooltipSizeX + tooltipPositionX;
                yield (total - startX - context.getPaddingX()) / 2 - component.getWidth(context.getFont()) / 2;
            }
            case "right" -> {
                int tooltipSizeX = (int)context.getTooltipSize().x;
                int tooltipPositionX = (int)context.getTooltipPosition().x;
                int total = tooltipSizeX + tooltipPositionX;
                yield total - startX - context.getPaddingX() - component.getWidth(context.getFont());
            }
            default -> 0;
        };
    }

    private int computeRatingAlignment(TooltipContext context, Component component, int startX) {
        return switch (PositionUtils.getRatingTextAlignment(context)) {
            case "middle" -> {
                int tooltipSizeX = (int)context.getTooltipSize().x;
                int tooltipPositionX = (int)context.getTooltipPosition().x;
                int total = tooltipSizeX + tooltipPositionX;
                yield (total - startX - context.getPaddingX()) / 2 - context.getFont().width((FormattedText)component) / 2;
            }
            case "right" -> {
                int tooltipSizeX = (int)context.getTooltipSize().x;
                int tooltipPositionX = (int)context.getTooltipPosition().x;
                int total = tooltipSizeX + tooltipPositionX;
                yield total - startX - context.getPaddingX() - context.getFont().width((FormattedText)component);
            }
            default -> 0;
        };
    }
}

