/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.config.parser;

public class ConfigColorParser {
    public static int[] parsePalette(String key) {
        int i;
        String[] rawColors = key.split("[,;\\s]+");
        int[] colors = new int[3];
        int length = Math.min(3, rawColors.length);
        int lastColor = -1;
        for (i = 0; i < length; ++i) {
            colors[i] = lastColor = ConfigColorParser.parseColor(rawColors[i].trim());
        }
        for (i = length; i < 3; ++i) {
            colors[i] = lastColor;
        }
        return colors;
    }

    public static int parseColor(String rawKey) {
        String key = rawKey.trim();
        if (key.startsWith("#")) {
            return ConfigColorParser.parseHex(key.substring(1));
        }
        if (key.startsWith("0x") || key.startsWith("0X")) {
            return ConfigColorParser.parseHex(key.substring(2));
        }
        long value = Long.parseLong(key);
        long argb = value <= 0xFFFFFFL ? 0xFF000000L | value : value;
        return (int)(argb & 0xFFFFFFFFL);
    }

    private static int parseHex(String rawHex) {
        String hex = rawHex.trim();
        if (hex.isEmpty()) {
            throw new IllegalArgumentException("Empty hex");
        }
        int length = hex.length();
        long value = Long.parseLong(hex, 16);
        if (length == 6) {
            value |= 0xFF000000L;
        } else if (length != 8) {
            return -1;
        }
        return (int)(value & 0xFFFFFFFFL);
    }
}

