/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.registry;

import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"ars_hex");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"ars_hex");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"ars_hex");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ars_hex");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"ars_hex");

    public static void registerRegistries(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        PARTICLES.register(bus);
        ENTITY_TYPES.register(bus);
        SOUNDS.register(bus);
        bus.addListener(ModRegistry::doTabsStuff);
    }

    static SoundEvent makeSound(@NotNull String name) {
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_hex", (String)name));
    }

    private static void doTabsStuff(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CreativeTabRegistry.BLOCKS.get()) {
            for (DeferredHolder item : ITEMS.getEntries()) {
                event.accept(() -> ((DeferredHolder)item).get());
            }
        }
    }
}

