/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.common.block.tile.TileCADAssembler;

public class BlockCADAssembler
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<BlockCADAssembler> CODEC = BlockCADAssembler.simpleCodec(BlockCADAssembler::new);

    public BlockCADAssembler(BlockBehaviour.Properties props) {
        super(props);
    }

    @NotNull
    public MapCodec<BlockCADAssembler> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, Level worldIn, @NotNull BlockPos pos) {
        IItemHandler handler = (IItemHandler)worldIn.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (handler != null) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)handler);
        }
        return 0;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player playerIn, @NotNull BlockHitResult rayTraceResult) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider container = state.getMenuProvider(world, pos);
        if (container != null) {
            playerIn.openMenu(container, pos);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileCADAssembler) {
            return (MenuProvider)te;
        }
        return null;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileCADAssembler(pos, state);
    }

    public void onRemove(BlockState state, @NotNull Level world, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        TileCADAssembler te;
        if (state.getBlock() != newState.getBlock() && !isMoving && (te = (TileCADAssembler)world.getBlockEntity(pos)) != null) {
            for (int i = 0; i < te.getInventory().getSlots(); ++i) {
                ItemStack stack = te.getInventory().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }
}

