/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileConjured;

public class BlockConjured
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty SOLID = BooleanProperty.create((String)"solid");
    public static final BooleanProperty LIGHT = BooleanProperty.create((String)"light");
    public static final BooleanProperty BLOCK_UP = BooleanProperty.create((String)"block_up");
    public static final BooleanProperty BLOCK_DOWN = BooleanProperty.create((String)"block_down");
    public static final BooleanProperty BLOCK_NORTH = BooleanProperty.create((String)"block_north");
    public static final BooleanProperty BLOCK_SOUTH = BooleanProperty.create((String)"block_south");
    public static final BooleanProperty BLOCK_WEST = BooleanProperty.create((String)"block_west");
    public static final BooleanProperty BLOCK_EAST = BooleanProperty.create((String)"block_east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape LIGHT_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BlockConjured(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)SOLID, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_SOUTH, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState stateIn, Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        BlockEntity inWorld = worldIn.getBlockEntity(pos);
        if (inWorld instanceof TileConjured) {
            ((TileConjured)inWorld).doParticles();
        }
    }

    public Integer getBeaconColorMultiplier(@NotNull BlockState state, LevelReader world, @NotNull BlockPos pos, @NotNull BlockPos beaconPos) {
        BlockEntity inWorld = world.getBlockEntity(pos);
        if (inWorld instanceof TileConjured) {
            return Psi.proxy.getColorForColorizer(((TileConjured)inWorld).colorizer);
        }
        return null;
    }

    public void tick(@NotNull BlockState state, ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        world.removeBlock(pos, false);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SOLID, LIGHT, BLOCK_UP, BLOCK_DOWN, BLOCK_NORTH, BLOCK_SOUTH, BLOCK_WEST, BLOCK_EAST, WATERLOGGED});
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        BooleanProperty prop;
        switch (facing) {
            case UP: {
                BooleanProperty booleanProperty = BLOCK_UP;
                break;
            }
            case NORTH: {
                BooleanProperty booleanProperty = BLOCK_NORTH;
                break;
            }
            case SOUTH: {
                BooleanProperty booleanProperty = BLOCK_SOUTH;
                break;
            }
            case WEST: {
                BooleanProperty booleanProperty = BLOCK_WEST;
                break;
            }
            case EAST: {
                BooleanProperty booleanProperty = BLOCK_EAST;
                break;
            }
            default: {
                BooleanProperty booleanProperty = prop = BLOCK_DOWN;
            }
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (state.getBlock() == facingState.getBlock() && state.getValue((Property)LIGHT) == facingState.getValue((Property)LIGHT) && state.getValue((Property)SOLID) == facingState.getValue((Property)SOLID)) {
            return (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(false));
    }

    public int getLightEmission(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)LIGHT) != false ? 15 : 0;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)SOLID) != false ? Shapes.block() : Shapes.empty();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)SOLID) != false ? Shapes.block() : LIGHT_SHAPE;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return 1.0f;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileConjured(pos, state);
    }
}

